/* Smart Download Redirector Admin Scripts */

jQuery(document).ready(function($) {
    
    // Initialize color picker
    if (typeof $.fn.wpColorPicker !== 'undefined') {
        $('.smartdr-color-picker').wpColorPicker();
    }
    
    // Rate limit fields toggle functionality
    function toggleRateLimitFields() {
        var isEnabled = $('#smartdr_rate_limit_enabled').is(':checked');
        $('#smartdr_rate_limit_enabled').closest('tr').nextAll('tr').toggle(isEnabled);
    }
    
    // Initial toggle for rate limit fields
    toggleRateLimitFields();
    
    // Toggle on change for rate limit
    $('#smartdr_rate_limit_enabled').on('change', toggleRateLimitFields);
    
    // Time window preset handling
    $('#smartdr_time_window_preset').on('change', function() {
        var value = $(this).val();
        if (value === 'custom') {
            $('#smartdr_custom_time_window').show();
            // Don't change the hidden field value, let user input custom value
        } else {
            $('#smartdr_custom_time_window').hide();
            $('#smartdr_rate_limit_time_window').val(value);
            $('#smartdr_rate_limit_time_window_hidden').val(value);
        }
    });
    
    $('#smartdr_rate_limit_time_window').on('input', function() {
        $('#smartdr_rate_limit_time_window_hidden').val($(this).val());
    });
    
    // Handle form submission to ensure the correct value is sent
    $('form').on('submit', function() {
        var preset = $('#smartdr_time_window_preset').val();
        var customValue = $('#smartdr_rate_limit_time_window').val();
        
        if (preset === 'custom') {
            $('#smartdr_rate_limit_time_window_hidden').attr('name', 'smartdr_rate_limit[time_window]');
            $('#smartdr_rate_limit_time_window').removeAttr('name');
        } else {
            $('#smartdr_rate_limit_time_window_hidden').attr('name', 'smartdr_rate_limit[time_window]').val(preset);
            $('#smartdr_rate_limit_time_window').removeAttr('name');
        }
    });
    
    // Default style values
    const defaultStyles = {
        heading_color: '#212121',
        heading_size: '32px',
        counter_color: '#00897B',
        counter_size: '36px',
        counter_font_weight: 'bold',
        background_color: '#ffffff',
        border_radius: '8px',
        border_size: '1px',
        border_color: '#dddddd',
        manual_link_size: '14px',
        manual_link_color: '#00897B',
        manual_link_hover_color: '#00695C'
    };

    const defaultDestinationStyles = {
        background_color: '#f8f9fa',
        border_size: '1px',
        border_color: '#dee2e6',
        border_radius: '4px',
        text_size: '14px'
    };

    // Reset styles button click handler
    $('#smartdr-reset-styles').on('click', function(e) {
        e.preventDefault();
        
        if (!confirm(smartdrAdmin.confirmResetStyles)) {
            return;
        }

        // Show loading state
        $(this).prop('disabled', true).val(smartdrAdmin.resetting);

        // Send AJAX request to reset styles
        $.post(ajaxurl, {
            action: 'smartdr_reset_styles',
            nonce: smartdrAdmin.resetStylesNonce
        }, function(response) {
            if (response.success) {
                alert(response.data.message);
                window.location.reload();
            } else {
                alert(smartdrAdmin.errorReset);
            }
        }).fail(function() {
            alert(smartdrAdmin.errorReset);
        }).always(function() {
            $('#smartdr-reset-styles').prop('disabled', false).val(smartdrAdmin.resetStyles);
        });
    });

    // Reset everything button click handler
    $('#smartdr-reset-everything').on('click', function(e) {
        e.preventDefault();
        
        if (!confirm(smartdrAdmin.confirmResetAll)) {
            return;
        }

        // Show loading state
        $(this).prop('disabled', true).val(smartdrAdmin.resetting);

        // Send AJAX request to reset all settings
        $.post(ajaxurl, {
            action: 'smartdr_reset_everything',
            nonce: smartdrAdmin.resetEverythingNonce
        }, function(response) {
            if (response.success) {
                alert(response.data.message);
                window.location.reload();
            } else {
                alert(smartdrAdmin.errorReset);
            }
        }).fail(function() {
            alert(smartdrAdmin.errorReset);
        }).always(function() {
            $('#smartdr-reset-everything').prop('disabled', false).val(smartdrAdmin.resetEverything);
        });
    });
    
}); 