/**
 * Format currency value
 */
export const formatCurrency = (value) => {
  return `$${parseFloat(value).toFixed(2)}`;
};

/**
 * Format condition text
 */
export const formatCondition = (type, value) => {
  return `Cart total >= ${formatCurrency(parseFloat(value))}`;
};

/**
 * Format discount text
 */
export const formatDiscount = (type, value) => {
  const formattedValue = parseFloat(value);
  return type === 'percentage'
    ? `${formattedValue}% off`
    : `${formatCurrency(formattedValue)} off`;
};

/**
 * Format shortcode with escaping
 */
export const getShortcode = (ruleId) => {
  // Ensure ruleId is a number and escape it
  const safeRuleId = parseInt(ruleId, 10);
  if (isNaN(safeRuleId)) {
    return '';
  }
  return `[dlift_discount_message id="${safeRuleId}"]`;
};