import { extendTheme } from '@chakra-ui/react';

const colors = {
  brand: {
    polynesianBlue: '#054a91',
    keppel: '#14b8a6',
    steelBlue: '#3e7cb1',
    safetyOrange: '#f17300',
    ecru: '#ddb771',
  },
  primary: {
    50: '#e6f6f4',
    100: '#b3e4df',
    200: '#80d2c9',
    300: '#4dc0b4',
    400: '#1aae9e',
    500: '#14b8a6', // keppel as main color
    600: '#108e80',
    700: '#0c655b',
    800: '#083b35',
    900: '#041210',
  },
  secondary: {
    50: '#e6edf5',
    100: '#b3cde2',
    200: '#80aecf',
    300: '#4d8ebc',
    400: '#3e7cb1', // steel blue
    500: '#054a91', // polynesian blue
    600: '#043a74',
    700: '#032a53',
    800: '#021932',
    900: '#010911',
  },
  accent: {
    50: '#fff2e6',
    100: '#ffd9b3',
    200: '#ffbf80',
    300: '#ffa64d',
    400: '#ff8c1a',
    500: '#f17300', // safety orange
    600: '#cc6100',
    700: '#994900',
    800: '#663000',
    900: '#331800',
  },
  neutral: {
    50: '#faf6ed',
    100: '#f1e6cc',
    200: '#e8d6aa',
    300: '#ddb771', // ecru
    400: '#d5a54d',
    500: '#cc942a',
    600: '#a37621',
    700: '#755518',
    800: '#47330f',
    900: '#1a1205',
  },
};

const theme = extendTheme({
  colors,
  components: {
    Button: {
      defaultProps: {
        colorScheme: 'primary',
      },
    },
    IconButton: {
      defaultProps: {
        colorScheme: 'primary',
      },
    },
  },
  styles: {
    global: {
      body: {
        bg: 'gray.50',
      },
    },
  },
});

export default theme;