import { useState, useCallback } from '@wordpress/element';

const defaultStyles = {
  padding: 16,
  backgroundColor: '#f0f0f1',
  textColor: '#1e1e1e',
  borderColor: '#ddd',
  borderWidth: 1,
  borderRadius: 4,
  fontSize: 16,
  fontWeight: 'normal',
  lineHeight: 1.5,
  textAlign: 'center',
  textTransform: 'none',
};

const defaultSuccessStyles = {
  ...defaultStyles,
  backgroundColor: '#edfaef',
  borderColor: '#4ab866',
};

export const useStyles = (initialProgressStyles = {}, initialSuccessStyles = {}) => {
  const [progressStyles, setProgressStyles] = useState({
    ...defaultStyles,
    ...initialProgressStyles,
  });

  const [successStyles, setSuccessStyles] = useState({
    ...defaultSuccessStyles,
    ...initialSuccessStyles,
  });

  const updateProgressStyle = useCallback((key, value) => {
    setProgressStyles(prev => ({
      ...prev,
      [key]: value,
    }));
  }, []);

  const updateSuccessStyle = useCallback((key, value) => {
    setSuccessStyles(prev => ({
      ...prev,
      [key]: value,
    }));
  }, []);

  const resetProgressStyles = useCallback(() => {
    setProgressStyles(defaultStyles);
  }, []);

  const resetSuccessStyles = useCallback(() => {
    setSuccessStyles(defaultSuccessStyles);
  }, []);

  return {
    progressStyles,
    successStyles,
    updateProgressStyle,
    updateSuccessStyle,
    resetProgressStyles,
    resetSuccessStyles,
  };
};