import {
  FormControl,
  FormLabel,
  VStack,
  Text,
  Box,
  Tabs,
  TabList,
  TabPanels,
  Tab,
  TabPanel,
  Slider,
  SliderTrack,
  SliderFilledTrack,
  SliderThumb,
  Input,
  Grid,
  GridItem,
  Select,
  ButtonGroup,
  IconButton,
  Tooltip,
  useColorModeValue,
  Badge,
  FormHelperText,
  Popover,
  PopoverTrigger,
  PopoverContent,
  PopoverBody,
  PopoverArrow,
  Icon,
  Flex,
  Divider,
  Accordion,
  AccordionItem,
  AccordionButton,
  AccordionPanel,
  AccordionIcon
} from '@chakra-ui/react';
import { InfoIcon } from '@chakra-ui/icons';
import {
  MdFormatAlignLeft,
  MdFormatAlignCenter,
  MdFormatAlignRight,
  MdFormatSize,
  MdFormatClear,
  MdFormatPaint,
  MdBorderStyle,
  MdLink,
  MdTransform,
  MdBlurOn,
  MdFilterAlt
} from 'react-icons/md';

const StyleControls = ({ type, styles, onChange }) => {
  const helperTextColor = useColorModeValue('gray.600', 'gray.400');
  const borderColor = useColorModeValue('gray.200', 'gray.600');
  const bgHover = useColorModeValue('gray.50', 'gray.700');
  const tabBg = useColorModeValue('white', 'gray.800');
  const activeBg = useColorModeValue('primary.50', 'gray.700');
  const sectionBg = useColorModeValue('gray.50', 'gray.700');

  return (
    <VStack spacing={4} align="stretch">
      <Accordion defaultIndex={[0]} allowMultiple>
        <AccordionItem
          border="1px"
          borderColor={borderColor}
          borderRadius="md"
          mb={4}
          bg={tabBg}
          _hover={{ borderColor: 'primary.500' }}
          transition="all 0.2s"
        >
          <AccordionButton
            p={4}
            _hover={{ bg: bgHover }}
            borderRadius="md"
          >
            <Box flex="1" textAlign="left">
              <Flex align="center">
                <Icon as={MdFormatSize} mr={2} color="primary.500" />
                <Text fontSize="md" fontWeight="medium">
                  Typography
                </Text>
              </Flex>
            </Box>
            <AccordionIcon />
          </AccordionButton>
          <AccordionPanel p={4} bg={sectionBg} borderBottomRadius="md">
            <VStack spacing={6} align="stretch">
              {/* Font Size */}
              <Box>
                <FormControl>
                  <Flex justify="space-between" align="center" mb={2}>
                    <FormLabel fontWeight="semibold" fontSize="sm" mb={0}>
                      Font Size
                    </FormLabel>
                    <Text fontSize="sm" color={helperTextColor}>
                      {styles.fontSize || 16}px
                    </Text>
                  </Flex>
                  <Slider
                    value={styles.fontSize || 16}
                    onChange={value => onChange(type, 'fontSize', value)}
                    min={12}
                    max={32}
                    step={1}
                    size="lg"
                  >
                    <SliderTrack bg="gray.200" h="3px">
                      <SliderFilledTrack bg="primary.500" />
                    </SliderTrack>
                    <SliderThumb
                      boxSize={4}
                      bg="white"
                      borderWidth="2px"
                      borderColor="primary.500"
                    />
                  </Slider>
                </FormControl>
              </Box>

              {/* Font Weight with Visual Preview */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Font Weight</FormLabel>
                  <Grid templateColumns="repeat(4, 1fr)" gap={2}>
                    {[
                      { label: 'Regular', value: 'normal', weight: '400' },
                      { label: 'Medium', value: 'medium', weight: '500' },
                      { label: 'Semibold', value: 'semibold', weight: '600' },
                      { label: 'Bold', value: 'bold', weight: '700' }
                    ].map((option) => (
                      <Box
                        key={option.value}
                        onClick={() => onChange(type, 'fontWeight', option.value)}
                        cursor="pointer"
                        bg={styles.fontWeight === option.value ? 'primary.50' : 'white'}
                        border="2px solid"
                        borderColor={styles.fontWeight === option.value ? 'primary.500' : borderColor}
                        borderRadius="md"
                        p={2}
                        textAlign="center"
                        transition="all 0.2s"
                        _hover={{
                          borderColor: 'primary.500',
                          transform: 'translateY(-1px)'
                        }}
                      >
                        <Text
                          fontSize="sm"
                          fontWeight={option.weight}
                          color={styles.fontWeight === option.value ? 'primary.700' : 'gray.700'}
                        >
                          {option.label}
                        </Text>
                      </Box>
                    ))}
                  </Grid>
                </FormControl>
              </Box>

              {/* Text Alignment with Modern Icons */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Text Alignment</FormLabel>
                  <Grid templateColumns="repeat(3, 1fr)" gap={2}>
                    {[
                      { icon: MdFormatAlignLeft, value: 'left', label: 'Left' },
                      { icon: MdFormatAlignCenter, value: 'center', label: 'Center' },
                      { icon: MdFormatAlignRight, value: 'right', label: 'Right' }
                    ].map((align) => (
                      <Box
                        key={align.value}
                        onClick={() => onChange(type, 'textAlign', align.value)}
                        cursor="pointer"
                        bg={styles.textAlign === align.value ? 'primary.50' : 'white'}
                        border="2px solid"
                        borderColor={styles.textAlign === align.value ? 'primary.500' : borderColor}
                        borderRadius="md"
                        p={2}
                        display="flex"
                        alignItems="center"
                        justifyContent="center"
                        transition="all 0.2s"
                        _hover={{
                          borderColor: 'primary.500',
                          transform: 'translateY(-1px)'
                        }}
                      >
                        <Icon
                          as={align.icon}
                          w={5}
                          h={5}
                          color={styles.textAlign === align.value ? 'primary.700' : 'gray.700'}
                        />
                      </Box>
                    ))}
                  </Grid>
                </FormControl>
              </Box>

              {/* Line Height */}
              <Box>
                <FormControl>
                  <Flex justify="space-between" align="center" mb={2}>
                    <FormLabel fontWeight="semibold" fontSize="sm" mb={0}>
                      Line Height
                    </FormLabel>
                    <Text fontSize="sm" color={helperTextColor}>
                      {styles.lineHeight || 1.5}
                    </Text>
                  </Flex>
                  <Slider
                    value={styles.lineHeight || 1.5}
                    onChange={value => onChange(type, 'lineHeight', value)}
                    min={1}
                    max={2.5}
                    step={0.1}
                    size="lg"
                  >
                    <SliderTrack bg="gray.200" h="3px">
                      <SliderFilledTrack bg="primary.500" />
                    </SliderTrack>
                    <SliderThumb
                      boxSize={4}
                      bg="white"
                      borderWidth="2px"
                      borderColor="primary.500"
                    />
                  </Slider>
                </FormControl>
              </Box>

              {/* Letter Spacing */}
              <Box>
                <FormControl>
                  <Flex justify="space-between" align="center" mb={2}>
                    <FormLabel fontWeight="semibold" fontSize="sm" mb={0}>
                      Letter Spacing
                    </FormLabel>
                    <Text fontSize="sm" color={helperTextColor}>
                      {styles.letterSpacing || 0}px
                    </Text>
                  </Flex>
                  <Slider
                    value={styles.letterSpacing || 0}
                    onChange={value => onChange(type, 'letterSpacing', value)}
                    min={-2}
                    max={10}
                    step={0.5}
                    size="lg"
                  >
                    <SliderTrack bg="gray.200" h="3px">
                      <SliderFilledTrack bg="primary.500" />
                    </SliderTrack>
                    <SliderThumb
                      boxSize={4}
                      bg="white"
                      borderWidth="2px"
                      borderColor="primary.500"
                    />
                  </Slider>
                </FormControl>
              </Box>

              {/* Text Decoration with Visual Examples */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Text Decoration</FormLabel>
                  <Grid templateColumns="repeat(2, 1fr)" gap={3}>
                    {[
                      { label: 'None', value: 'none' },
                      { label: 'Underline', value: 'underline' },
                      { label: 'Line Through', value: 'line-through' },
                      { label: 'Both', value: 'underline line-through' }
                    ].map((option) => (
                      <Box
                        key={option.value}
                        onClick={() => onChange(type, 'textDecoration', option.value)}
                        cursor="pointer"
                        bg={styles.textDecoration === option.value ? 'primary.50' : 'white'}
                        border="2px solid"
                        borderColor={styles.textDecoration === option.value ? 'primary.500' : borderColor}
                        borderRadius="md"
                        p={2}
                        textAlign="center"
                        transition="all 0.2s"
                        _hover={{
                          borderColor: 'primary.500',
                          transform: 'translateY(-1px)'
                        }}
                      >
                        <Text
                          fontSize="sm"
                          textDecoration={option.value}
                          color={styles.textDecoration === option.value ? 'primary.700' : 'gray.700'}
                        >
                          {option.label}
                        </Text>
                      </Box>
                    ))}
                  </Grid>
                </FormControl>
              </Box>

              {/* Text Transformation */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Text Transformation</FormLabel>
                  <Grid templateColumns="repeat(4, 1fr)" gap={2}>
                    {[
                      { label: 'None', value: 'none' },
                      { label: 'Uppercase', value: 'uppercase' },
                      { label: 'Lowercase', value: 'lowercase' },
                      { label: 'Capitalize', value: 'capitalize' }
                    ].map((option) => (
                      <Box
                        key={option.value}
                        onClick={() => onChange(type, 'textTransform', option.value)}
                        cursor="pointer"
                        bg={styles.textTransform === option.value ? 'primary.50' : 'white'}
                        border="2px solid"
                        borderColor={styles.textTransform === option.value ? 'primary.500' : borderColor}
                        borderRadius="md"
                        p={2}
                        textAlign="center"
                        transition="all 0.2s"
                        _hover={{
                          borderColor: 'primary.500',
                          transform: 'translateY(-1px)'
                        }}
                      >
                        <Text
                          fontSize="sm"
                          textTransform={option.value}
                          color={styles.textTransform === option.value ? 'primary.700' : 'gray.700'}
                        >
                          {option.label}
                        </Text>
                      </Box>
                    ))}
                  </Grid>
                </FormControl>
              </Box>
            </VStack>
          </AccordionPanel>
        </AccordionItem>

        <AccordionItem
          border="1px"
          borderColor={borderColor}
          borderRadius="md"
          mb={4}
          bg={tabBg}
          _hover={{ borderColor: 'primary.500' }}
          transition="all 0.2s"
        >
          <AccordionButton
            p={4}
            _hover={{ bg: bgHover }}
            borderRadius="md"
          >
            <Box flex="1" textAlign="left">
              <Flex align="center">
                <Icon as={MdFormatPaint} mr={2} color="primary.500" />
                <Text fontSize="md" fontWeight="medium">
                  Colors & Background
                </Text>
              </Flex>
            </Box>
            <AccordionIcon />
          </AccordionButton>
          <AccordionPanel p={4} bg={sectionBg} borderBottomRadius="md">
            <VStack spacing={6} align="stretch">
              {/* Text Color */}
              <Box
                bg="white"
                p={4}
                borderRadius="md"
                borderWidth="1px"
                borderColor={borderColor}
                boxShadow="sm"
                _hover={{ boxShadow: 'md', borderColor: 'primary.500' }}
                transition="all 0.2s"
              >
                <FormControl>
                  <Flex justify="space-between" align="center" mb={2}>
                    <FormLabel fontWeight="semibold" fontSize="sm" mb={0}>
                      Text Color
                    </FormLabel>
                    <Box
                      w="24px"
                      h="24px"
                      bg={styles.textColor || '#1e1e1e'}
                      borderRadius="full"
                      borderWidth="1px"
                      borderColor="gray.300"
                    />
                  </Flex>
                  <Flex align="center" mb={2}>
                    <Input
                      type="color"
                      value={styles.textColor || '#1e1e1e'}
                      onChange={e => onChange(type, 'textColor', e.target.value)}
                      w="40px"
                      h="40px"
                      cursor="pointer"
                      mr={2}
                    />
                    <Input
                      value={styles.textColor || '#1e1e1e'}
                      onChange={e => onChange(type, 'textColor', e.target.value)}
                      placeholder="#000000"
                      size="sm"
                      w="full"
                    />
                    <Tooltip label="Click to pick a color" placement="top" hasArrow>
                      <Icon as={MdFormatPaint} ml={2} color="primary.500" w={5} h={5} cursor="pointer" />
                    </Tooltip>
                  </Flex>
                </FormControl>
              </Box>

              {/* Background Color */}
              <Box
                bg="white"
                p={4}
                borderRadius="md"
                borderWidth="1px"
                borderColor={borderColor}
                boxShadow="sm"
                _hover={{ boxShadow: 'md', borderColor: 'primary.500' }}
                transition="all 0.2s"
              >
                <FormControl>
                  <Flex justify="space-between" align="center" mb={2}>
                    <FormLabel fontWeight="semibold" fontSize="sm" mb={0}>
                      Background Color
                    </FormLabel>
                    <Box
                      w="24px"
                      h="24px"
                      bg={styles.backgroundColor || '#f0f0f1'}
                      borderRadius="full"
                      borderWidth="1px"
                      borderColor="gray.300"
                    />
                  </Flex>
                  <Flex align="center" mb={2}>
                    <Input
                      type="color"
                      value={styles.backgroundColor || '#f0f0f1'}
                      onChange={e => onChange(type, 'backgroundColor', e.target.value)}
                      w="40px"
                      h="40px"
                      cursor="pointer"
                      mr={2}
                    />
                    <Input
                      value={styles.backgroundColor || '#f0f0f1'}
                      onChange={e => onChange(type, 'backgroundColor', e.target.value)}
                      placeholder="#000000"
                      size="sm"
                      w="full"
                    />
                    <Tooltip label="Click to pick a color" placement="top" hasArrow>
                      <Icon as={MdFormatPaint} ml={2} color="primary.500" w={5} h={5} cursor="pointer" />
                    </Tooltip>
                  </Flex>
                </FormControl>
              </Box>

              {/* Background Opacity */}
              <Box
                bg="white"
                p={4}
                borderRadius="md"
                borderWidth="1px"
                borderColor={borderColor}
                boxShadow="sm"
                _hover={{ boxShadow: 'md', borderColor: 'primary.500' }}
                transition="all 0.2s"
              >
                <FormControl>
                  <Flex justify="space-between" align="center" mb={2}>
                    <FormLabel fontWeight="semibold" fontSize="sm" mb={0}>
                      Background Opacity
                    </FormLabel>
                    <Text fontSize="sm" color={helperTextColor}>
                      {styles.backgroundOpacity || 1}
                    </Text>
                  </Flex>
                  <Slider
                    value={styles.backgroundOpacity || 1}
                    onChange={value => onChange(type, 'backgroundOpacity', value)}
                    min={0}
                    max={1}
                    step={0.1}
                    size="lg"
                  >
                    <SliderTrack bg="gray.200" h="3px">
                      <SliderFilledTrack bg="primary.500" />
                    </SliderTrack>
                    <SliderThumb
                      boxSize={4}
                      bg="white"
                      borderWidth="2px"
                      borderColor="primary.500"
                    />
                  </Slider>
                </FormControl>
              </Box>

              {/* Text Opacity */}
              <Box
                bg="white"
                p={4}
                borderRadius="md"
                borderWidth="1px"
                borderColor={borderColor}
                boxShadow="sm"
                _hover={{ boxShadow: 'md', borderColor: 'primary.500' }}
                transition="all 0.2s"
              >
                <FormControl>
                  <Flex justify="space-between" align="center" mb={2}>
                    <FormLabel fontWeight="semibold" fontSize="sm" mb={0}>
                      Text Opacity
                    </FormLabel>
                    <Text fontSize="sm" color={helperTextColor}>
                      {styles.textOpacity || 1}
                    </Text>
                  </Flex>
                  <Slider
                    value={styles.textOpacity || 1}
                    onChange={value => onChange(type, 'textOpacity', value)}
                    min={0}
                    max={1}
                    step={0.1}
                    size="lg"
                  >
                    <SliderTrack bg="gray.200" h="3px">
                      <SliderFilledTrack bg="primary.500" />
                    </SliderTrack>
                    <SliderThumb
                      boxSize={4}
                      bg="white"
                      borderWidth="2px"
                      borderColor="primary.500"
                    />
                  </Slider>
                </FormControl>
              </Box>
            </VStack>
          </AccordionPanel>
        </AccordionItem>

        <AccordionItem
          border="1px"
          borderColor={borderColor}
          borderRadius="md"
          mb={4}
          bg={tabBg}
          _hover={{ borderColor: 'primary.500' }}
          transition="all 0.2s"
        >
          <AccordionButton
            p={4}
            _hover={{ bg: bgHover }}
            borderRadius="md"
          >
            <Box flex="1" textAlign="left">
              <Flex align="center">
                <Icon as={MdBorderStyle} mr={2} color="primary.500" />
                <Text fontSize="md" fontWeight="medium">
                  Padding
                </Text>
              </Flex>
            </Box>
            <AccordionIcon />
          </AccordionButton>
          <AccordionPanel p={4} bg={sectionBg} borderBottomRadius="md">
            <VStack spacing={6} align="stretch">
              {/* Padding Controls */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Padding</FormLabel>
                  <Grid templateColumns="repeat(2, 1fr)" gap={4}>
                    {/* Top Padding */}
                    <Box
                      bg="white"
                      p={3}
                      borderRadius="md"
                      borderWidth="1px"
                      borderColor={borderColor}
                      _hover={{ borderColor: 'primary.500' }}
                    >
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm" fontWeight="medium">Top</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.paddingTop || 16}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.paddingTop || 16}
                        onChange={value => onChange(type, 'paddingTop', value)}
                        min={0}
                        max={50}
                        step={1}
                        size="sm"
                      >
                        <SliderTrack bg="gray.200" h="2px">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                      </Slider>
                    </Box>

                    {/* Right Padding */}
                    <Box
                      bg="white"
                      p={3}
                      borderRadius="md"
                      borderWidth="1px"
                      borderColor={borderColor}
                      _hover={{ borderColor: 'primary.500' }}
                    >
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm" fontWeight="medium">Right</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.paddingRight || 16}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.paddingRight || 16}
                        onChange={value => onChange(type, 'paddingRight', value)}
                        min={0}
                        max={50}
                        step={1}
                        size="sm"
                      >
                        <SliderTrack bg="gray.200" h="2px">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                      </Slider>
                    </Box>

                    {/* Bottom Padding */}
                    <Box
                      bg="white"
                      p={3}
                      borderRadius="md"
                      borderWidth="1px"
                      borderColor={borderColor}
                      _hover={{ borderColor: 'primary.500' }}
                    >
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm" fontWeight="medium">Bottom</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.paddingBottom || 16}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.paddingBottom || 16}
                        onChange={value => onChange(type, 'paddingBottom', value)}
                        min={0}
                        max={50}
                        step={1}
                        size="sm"
                      >
                        <SliderTrack bg="gray.200" h="2px">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                      </Slider>
                    </Box>

                    {/* Left Padding */}
                    <Box
                      bg="white"
                      p={3}
                      borderRadius="md"
                      borderWidth="1px"
                      borderColor={borderColor}
                      _hover={{ borderColor: 'primary.500' }}
                    >
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm" fontWeight="medium">Left</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.paddingLeft || 16}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.paddingLeft || 16}
                        onChange={value => onChange(type, 'paddingLeft', value)}
                        min={0}
                        max={50}
                        step={1}
                        size="sm"
                      >
                        <SliderTrack bg="gray.200" h="2px">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                      </Slider>
                    </Box>
                  </Grid>

                  {/* Link/Unlink Padding Button */}
                  <Box mt={2} textAlign="center">
                    <Tooltip label="Link/Unlink padding values" placement="top" hasArrow>
                      <IconButton
                        size="sm"
                        icon={<Icon as={MdLink} />}
                        variant="ghost"
                        colorScheme="primary"
                        onClick={() => {
                          // If padding values are different, set all to the top padding value
                          // If they're the same, do nothing (they remain linked)
                          const topPadding = styles.paddingTop || 16;
                          onChange(type, 'paddingRight', topPadding);
                          onChange(type, 'paddingBottom', topPadding);
                          onChange(type, 'paddingLeft', topPadding);
                        }}
                      />
                    </Tooltip>
                  </Box>
                </FormControl>
              </Box>
            </VStack>
          </AccordionPanel>
        </AccordionItem>

        <AccordionItem
          border="1px"
          borderColor={borderColor}
          borderRadius="md"
          mb={4}
          bg={tabBg}
          _hover={{ borderColor: 'primary.500' }}
          transition="all 0.2s"
        >
          <AccordionButton
            p={4}
            _hover={{ bg: bgHover }}
            borderRadius="md"
          >
            <Box flex="1" textAlign="left">
              <Flex align="center">
                <Icon as={MdBorderStyle} mr={2} color="primary.500" />
                <Text fontSize="md" fontWeight="medium">
                  Border
                </Text>
              </Flex>
            </Box>
            <AccordionIcon />
          </AccordionButton>
          <AccordionPanel p={4} bg={sectionBg} borderBottomRadius="md">
            <Grid templateColumns="repeat(2, 1fr)" gap={6}>
              {/* Border Type */}
              <GridItem colSpan={2}>
                <FormControl>
                  <FormLabel fontWeight="medium">
                    Border Type
                    <Tooltip label="Choose border style" placement="top" hasArrow>
                      <Icon as={InfoIcon} ml={2} color={helperTextColor} w={4} h={4} cursor="help" />
                    </Tooltip>
                  </FormLabel>
                  <Grid templateColumns="repeat(3, 1fr)" gap={2}>
                    {[
                      { label: 'Solid', value: 'solid' },
                      { label: 'Dashed', value: 'dashed' },
                      { label: 'Dotted', value: 'dotted' }
                    ].map((option) => (
                      <Box
                        key={option.value}
                        onClick={() => onChange(type, 'borderStyle', option.value)}
                        cursor="pointer"
                        bg={styles.borderStyle === option.value ? 'primary.50' : 'white'}
                        border="2px"
                        borderStyle={option.value}
                        borderColor={styles.borderStyle === option.value ? 'primary.500' : borderColor}
                        borderRadius="md"
                        p={2}
                        textAlign="center"
                        transition="all 0.2s"
                        _hover={{
                          borderColor: 'primary.500',
                          transform: 'translateY(-1px)'
                        }}
                      >
                        <Text
                          fontSize="sm"
                          color={styles.borderStyle === option.value ? 'primary.700' : 'gray.700'}
                        >
                          {option.label}
                        </Text>
                      </Box>
                    ))}
                  </Grid>
                </FormControl>
              </GridItem>

              {/* Border Width */}
              <GridItem>
                <FormControl>
                  <FormLabel fontWeight="medium">
                    Border Width
                    <Tooltip label="Adjust the border thickness" placement="top" hasArrow>
                      <Icon as={InfoIcon} ml={2} color={helperTextColor} w={4} h={4} cursor="help" />
                    </Tooltip>
                  </FormLabel>
                  <Box
                    bg="white"
                    p={3}
                    borderRadius="md"
                    borderWidth="1px"
                    borderColor={borderColor}
                    _hover={{ borderColor: 'primary.500' }}
                    transition="all 0.2s"
                  >
                    <Slider
                      value={styles.borderWidth || 1}
                      onChange={value => onChange(type, 'borderWidth', value)}
                      min={0}
                      max={10}
                      step={0.5}
                      size="sm"
                    >
                      <SliderTrack bg={borderColor}>
                        <SliderFilledTrack bg="primary.500" />
                      </SliderTrack>
                      <SliderThumb
                        boxSize={3}
                        bg="white"
                        borderWidth="1px"
                        borderColor="primary.500"
                      />
                    </Slider>
                    <Text fontSize="sm" color={helperTextColor} mt={2} textAlign="right">
                      {styles.borderWidth || 1}px
                    </Text>
                  </Box>
                </FormControl>
              </GridItem>

              {/* Border Color */}
              <GridItem>
                <FormControl>
                  <FormLabel fontWeight="medium">
                    Border Color
                    <Tooltip label="Choose the border color" placement="top" hasArrow>
                      <Icon as={InfoIcon} ml={2} color={helperTextColor} w={4} h={4} cursor="help" />
                    </Tooltip>
                  </FormLabel>
                  <Box
                    bg="white"
                    p={3}
                    borderRadius="md"
                    borderWidth="1px"
                    borderColor={borderColor}
                    _hover={{ borderColor: 'primary.500' }}
                    transition="all 0.2s"
                  >
                    <Flex align="center">
                      <Input
                        type="color"
                        value={styles.borderColor || '#ddd'}
                        onChange={e => onChange(type, 'borderColor', e.target.value)}
                        w="40px"
                        h="40px"
                        cursor="pointer"
                        mr={2}
                      />
                      <Input
                        value={styles.borderColor || '#ddd'}
                        onChange={e => onChange(type, 'borderColor', e.target.value)}
                        placeholder="#000000"
                        size="sm"
                        flex="1"
                      />
                    </Flex>
                  </Box>
                </FormControl>
              </GridItem>

              {/* Border Radius */}
              <GridItem colSpan={2}>
                <FormControl>
                  <FormLabel fontWeight="medium">
                    Border Radius
                    <Tooltip label="Adjust the corner roundness" placement="top" hasArrow>
                      <Icon as={InfoIcon} ml={2} color={helperTextColor} w={4} h={4} cursor="help" />
                    </Tooltip>
                  </FormLabel>
                  <Box
                    bg="white"
                    p={3}
                    borderRadius="md"
                    borderWidth="1px"
                    borderColor={borderColor}
                    _hover={{ borderColor: 'primary.500' }}
                    transition="all 0.2s"
                  >
                    <Slider
                      value={styles.borderRadius || 4}
                      onChange={value => onChange(type, 'borderRadius', value)}
                      min={0}
                      max={20}
                      step={0.5}
                      size="sm"
                    >
                      <SliderTrack bg={borderColor}>
                        <SliderFilledTrack bg="primary.500" />
                      </SliderTrack>
                      <SliderThumb
                        boxSize={3}
                        bg="white"
                        borderWidth="1px"
                        borderColor="primary.500"
                      />
                    </Slider>
                    <Text fontSize="sm" color={helperTextColor} mt={2} textAlign="right">
                      {styles.borderRadius || 4}px
                    </Text>
                  </Box>
                </FormControl>
              </GridItem>
            </Grid>
          </AccordionPanel>
        </AccordionItem>

        <AccordionItem
          border="1px"
          borderColor={borderColor}
          borderRadius="md"
          mb={4}
          bg={tabBg}
          _hover={{ borderColor: 'primary.500' }}
          transition="all 0.2s"
        >
          <AccordionButton
            p={4}
            _hover={{ bg: bgHover }}
            borderRadius="md"
          >
            <Box flex="1" textAlign="left">
              <Flex align="center">
                <Icon as={MdTransform} mr={2} color="primary.500" />
                <Text fontSize="md" fontWeight="medium">
                  Transform
                </Text>
              </Flex>
            </Box>
            <AccordionIcon />
          </AccordionButton>
          <AccordionPanel p={4} bg={sectionBg} borderBottomRadius="md">
            <VStack spacing={6} align="stretch">
              {/* Scale Transform */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Scale</FormLabel>
                  <Grid templateColumns="repeat(2, 1fr)" gap={4}>
                    {/* Scale X */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm" fontWeight="medium">Scale X</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.scaleX || 1}
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.scaleX || 1}
                        onChange={value => onChange(type, 'scaleX', value)}
                        min={0}
                        max={2}
                        step={0.1}
                        size="sm"
                      >
                        <SliderTrack bg="gray.200" h="2px">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                      </Slider>
                    </Box>

                    {/* Scale Y */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm" fontWeight="medium">Scale Y</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.scaleY || 1}
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.scaleY || 1}
                        onChange={value => onChange(type, 'scaleY', value)}
                        min={0}
                        max={2}
                        step={0.1}
                        size="sm"
                      >
                        <SliderTrack bg="gray.200" h="2px">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                      </Slider>
                    </Box>
                  </Grid>
                </FormControl>
              </Box>

              {/* Rotate */}
              <Box>
                <FormControl>
                  <Flex justify="space-between" align="center" mb={2}>
                    <FormLabel fontWeight="semibold" fontSize="sm" mb={0}>
                      Rotate
                    </FormLabel>
                    <Text fontSize="sm" color={helperTextColor}>
                      {styles.rotate || 0}°
                    </Text>
                  </Flex>
                  <Slider
                    value={styles.rotate || 0}
                    onChange={value => onChange(type, 'rotate', value)}
                    min={-180}
                    max={180}
                    step={1}
                    size="sm"
                  >
                    <SliderTrack bg="gray.200" h="2px">
                      <SliderFilledTrack bg="primary.500" />
                    </SliderTrack>
                    <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                  </Slider>
                </FormControl>
              </Box>

              {/* Translate */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Translate</FormLabel>
                  <Grid templateColumns="repeat(2, 1fr)" gap={4}>
                    {/* Translate X */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm" fontWeight="medium">X Axis</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.translateX || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.translateX || 0}
                        onChange={value => onChange(type, 'translateX', value)}
                        min={-50}
                        max={50}
                        step={1}
                        size="sm"
                      >
                        <SliderTrack bg="gray.200" h="2px">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                      </Slider>
                    </Box>

                    {/* Translate Y */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm" fontWeight="medium">Y Axis</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.translateY || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.translateY || 0}
                        onChange={value => onChange(type, 'translateY', value)}
                        min={-50}
                        max={50}
                        step={1}
                        size="sm"
                      >
                        <SliderTrack bg="gray.200" h="2px">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                      </Slider>
                    </Box>
                  </Grid>
                </FormControl>
              </Box>

              {/* Skew */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Skew</FormLabel>
                  <Grid templateColumns="repeat(2, 1fr)" gap={4}>
                    {/* Skew X */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm" fontWeight="medium">X Axis</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.skewX || 0}°
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.skewX || 0}
                        onChange={value => onChange(type, 'skewX', value)}
                        min={-45}
                        max={45}
                        step={1}
                        size="sm"
                      >
                        <SliderTrack bg="gray.200" h="2px">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                      </Slider>
                    </Box>

                    {/* Skew Y */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm" fontWeight="medium">Y Axis</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.skewY || 0}°
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.skewY || 0}
                        onChange={value => onChange(type, 'skewY', value)}
                        min={-45}
                        max={45}
                        step={1}
                        size="sm"
                      >
                        <SliderTrack bg="gray.200" h="2px">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb boxSize={3} bg="white" borderWidth="1px" borderColor="primary.500" />
                      </Slider>
                    </Box>
                  </Grid>
                </FormControl>
              </Box>

              {/* Transform Origin */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Transform Origin</FormLabel>
                  <Grid templateColumns="repeat(3, 1fr)" gap={2}>
                    {[
                      { label: 'Top Left', value: 'top left' },
                      { label: 'Top Center', value: 'top center' },
                      { label: 'Top Right', value: 'top right' },
                      { label: 'Center Left', value: 'center left' },
                      { label: 'Center', value: 'center' },
                      { label: 'Center Right', value: 'center right' },
                      { label: 'Bottom Left', value: 'bottom left' },
                      { label: 'Bottom Center', value: 'bottom center' },
                      { label: 'Bottom Right', value: 'bottom right' }
                    ].map((option) => (
                      <Box
                        key={option.value}
                        onClick={() => onChange(type, 'transformOrigin', option.value)}
                        cursor="pointer"
                        bg={styles.transformOrigin === option.value ? 'primary.50' : 'white'}
                        border="2px solid"
                        borderColor={styles.transformOrigin === option.value ? 'primary.500' : borderColor}
                        borderRadius="md"
                        p={2}
                        textAlign="center"
                        transition="all 0.2s"
                        _hover={{
                          borderColor: 'primary.500',
                          transform: 'translateY(-1px)'
                        }}
                      >
                        <Text
                          fontSize="sm"
                          color={styles.transformOrigin === option.value ? 'primary.700' : 'gray.700'}
                        >
                          {option.label}
                        </Text>
                      </Box>
                    ))}
                  </Grid>
                </FormControl>
              </Box>
            </VStack>
          </AccordionPanel>
        </AccordionItem>

        <AccordionItem
          border="1px"
          borderColor={borderColor}
          borderRadius="md"
          mb={4}
          bg={tabBg}
          _hover={{ borderColor: 'primary.500' }}
          transition="all 0.2s"
        >
          <AccordionButton
            p={4}
            _hover={{ bg: bgHover }}
            borderRadius="md"
          >
            <Box flex="1" textAlign="left">
              <Flex align="center">
                <Icon as={MdBlurOn} mr={2} color="primary.500" />
                <Text fontSize="md" fontWeight="medium">
                  Shadows
                </Text>
              </Flex>
            </Box>
            <AccordionIcon />
          </AccordionButton>
          <AccordionPanel p={4} bg={sectionBg} borderBottomRadius="md">
            <VStack spacing={6} align="stretch">
              {/* Box Shadow Controls */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Box Shadow</FormLabel>
                  <VStack spacing={4} align="stretch">
                    {/* Offset X */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Offset X</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.boxShadowX || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.boxShadowX || 0}
                        onChange={value => onChange(type, 'boxShadowX', value)}
                        min={-20}
                        max={20}
                        step={1}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Offset Y */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Offset Y</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.boxShadowY || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.boxShadowY || 0}
                        onChange={value => onChange(type, 'boxShadowY', value)}
                        min={-20}
                        max={20}
                        step={1}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Blur Radius */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Blur Radius</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.boxShadowBlur || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.boxShadowBlur || 0}
                        onChange={value => onChange(type, 'boxShadowBlur', value)}
                        min={0}
                        max={50}
                        step={1}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Spread Radius */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Spread Radius</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.boxShadowSpread || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.boxShadowSpread || 0}
                        onChange={value => onChange(type, 'boxShadowSpread', value)}
                        min={-20}
                        max={20}
                        step={1}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Shadow Color */}
                    <FormControl>
                      <FormLabel fontSize="sm">Shadow Color</FormLabel>
                      <Input
                        type="color"
                        value={styles.boxShadowColor || 'rgba(0,0,0,0.1)'}
                        onChange={e => onChange(type, 'boxShadowColor', e.target.value)}
                      />
                    </FormControl>
                  </VStack>
                </FormControl>
              </Box>

              <Divider />

              {/* Text Shadow Controls */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Text Shadow</FormLabel>
                  <VStack spacing={4} align="stretch">
                    {/* Offset X */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Offset X</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.textShadowX || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.textShadowX || 0}
                        onChange={value => onChange(type, 'textShadowX', value)}
                        min={-10}
                        max={10}
                        step={1}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Offset Y */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Offset Y</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.textShadowY || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.textShadowY || 0}
                        onChange={value => onChange(type, 'textShadowY', value)}
                        min={-10}
                        max={10}
                        step={1}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Blur Radius */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Blur Radius</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.textShadowBlur || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.textShadowBlur || 0}
                        onChange={value => onChange(type, 'textShadowBlur', value)}
                        min={0}
                        max={20}
                        step={1}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Shadow Color */}
                    <FormControl>
                      <FormLabel fontSize="sm">Shadow Color</FormLabel>
                      <Input
                        type="color"
                        value={styles.textShadowColor || 'rgba(0,0,0,0.1)'}
                        onChange={e => onChange(type, 'textShadowColor', e.target.value)}
                      />
                    </FormControl>
                  </VStack>
                </FormControl>
              </Box>
            </VStack>
          </AccordionPanel>
        </AccordionItem>

        <AccordionItem
          border="1px"
          borderColor={borderColor}
          borderRadius="md"
          mb={4}
          bg={tabBg}
          _hover={{ borderColor: 'primary.500' }}
          transition="all 0.2s"
        >
          <AccordionButton
            p={4}
            _hover={{ bg: bgHover }}
            borderRadius="md"
          >
            <Box flex="1" textAlign="left">
              <Flex align="center">
                <Icon as={MdFilterAlt} mr={2} color="primary.500" />
                <Text fontSize="md" fontWeight="medium">
                  Filter Effects
                </Text>
              </Flex>
            </Box>
            <AccordionIcon />
          </AccordionButton>
          <AccordionPanel p={4} bg={sectionBg} borderBottomRadius="md">
            <VStack spacing={6} align="stretch">
              {/* Basic Filters */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Basic Filters</FormLabel>
                  <VStack spacing={4} align="stretch">
                    {/* Blur */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Blur</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.blur || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.blur || 0}
                        onChange={value => onChange(type, 'blur', value)}
                        min={0}
                        max={20}
                        step={1}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Brightness */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Brightness</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.brightness || 100}%
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.brightness || 100}
                        onChange={value => onChange(type, 'brightness', value)}
                        min={0}
                        max={200}
                        step={5}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Contrast */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Contrast</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.contrast || 100}%
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.contrast || 100}
                        onChange={value => onChange(type, 'contrast', value)}
                        min={0}
                        max={200}
                        step={5}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Saturation */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Saturation</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.saturation || 100}%
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.saturation || 100}
                        onChange={value => onChange(type, 'saturation', value)}
                        min={0}
                        max={200}
                        step={5}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Hue Rotate */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Hue Rotate</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.hue || 0}°
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.hue || 0}
                        onChange={value => onChange(type, 'hue', value)}
                        min={0}
                        max={360}
                        step={5}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>
                  </VStack>
                </FormControl>
              </Box>

              <Divider />

              {/* Backdrop Filters */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">Backdrop Filters</FormLabel>
                  <VStack spacing={4} align="stretch">
                    {/* Backdrop Blur */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Backdrop Blur</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.backdropBlur || 0}px
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.backdropBlur || 0}
                        onChange={value => onChange(type, 'backdropBlur', value)}
                        min={0}
                        max={20}
                        step={1}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Backdrop Brightness */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Backdrop Brightness</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.backdropBrightness || 100}%
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.backdropBrightness || 100}
                        onChange={value => onChange(type, 'backdropBrightness', value)}
                        min={0}
                        max={200}
                        step={5}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Backdrop Contrast */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Backdrop Contrast</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.backdropContrast || 100}%
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.backdropContrast || 100}
                        onChange={value => onChange(type, 'backdropContrast', value)}
                        min={0}
                        max={200}
                        step={5}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>

                    {/* Backdrop Saturation */}
                    <Box>
                      <Flex justify="space-between" align="center" mb={2}>
                        <Text fontSize="sm">Backdrop Saturation</Text>
                        <Text fontSize="sm" color={helperTextColor}>
                          {styles.backdropSaturation || 100}%
                        </Text>
                      </Flex>
                      <Slider
                        value={styles.backdropSaturation || 100}
                        onChange={value => onChange(type, 'backdropSaturation', value)}
                        min={0}
                        max={200}
                        step={5}
                      >
                        <SliderTrack bg="gray.200">
                          <SliderFilledTrack bg="primary.500" />
                        </SliderTrack>
                        <SliderThumb />
                      </Slider>
                    </Box>
                  </VStack>
                </FormControl>
              </Box>

              <Divider />

              {/* Mix Blend Mode */}
              <Box>
                <FormControl>
                  <FormLabel fontWeight="semibold" fontSize="sm">
                    Mix Blend Mode
                    <Tooltip
                      label="Blend mode determines how the element's content blends with its background"
                      placement="top"
                      hasArrow
                    >
                      <Icon as={InfoIcon} ml={2} color={helperTextColor} w={4} h={4} cursor="help" />
                    </Tooltip>
                  </FormLabel>
                  <Grid templateColumns="repeat(3, 1fr)" gap={2}>
                    {[
                      { mode: 'normal', description: 'No blending applied' },
                      { mode: 'multiply', description: 'Multiplies colors, resulting in darker colors' },
                      { mode: 'screen', description: 'Multiplies inverse colors, resulting in lighter colors' },
                      { mode: 'overlay', description: 'Combines multiply and screen' },
                      { mode: 'darken', description: 'Retains the darkest colors' },
                      { mode: 'lighten', description: 'Retains the lightest colors' },
                      { mode: 'color-dodge', description: 'Brightens the background color' },
                      { mode: 'color-burn', description: 'Darkens the background color' },
                      { mode: 'hard-light', description: 'Similar to overlay, but with the layers swapped' },
                      { mode: 'soft-light', description: 'Softer version of hard-light' },
                      { mode: 'difference', description: 'Subtracts the darker color from the lighter' },
                      { mode: 'exclusion', description: 'Similar to difference with lower contrast' },
                      { mode: 'hue', description: 'Uses the hue of the blend color' },
                      { mode: 'saturation', description: 'Uses the saturation of the blend color' },
                      { mode: 'color', description: 'Uses the hue and saturation of the blend color' },
                      { mode: 'luminosity', description: 'Uses the luminosity of the blend color' }
                    ].map(({ mode, description }) => (
                      <Tooltip
                        key={mode}
                        label={description}
                        placement="top"
                        hasArrow
                      >
                        <Box
                          onClick={() => onChange(type, 'mixBlendMode', mode)}
                          cursor="pointer"
                          bg={styles.mixBlendMode === mode ? 'primary.50' : 'white'}
                          border="2px solid"
                          borderColor={styles.mixBlendMode === mode ? 'primary.500' : borderColor}
                          borderRadius="md"
                          p={2}
                          textAlign="center"
                          transition="all 0.2s"
                          _hover={{
                            borderColor: 'primary.500',
                            transform: 'translateY(-1px)',
                            boxShadow: 'sm'
                          }}
                        >
                          <Text
                            fontSize="sm"
                            color={styles.mixBlendMode === mode ? 'primary.700' : 'gray.700'}
                            fontWeight={styles.mixBlendMode === mode ? 'medium' : 'normal'}
                          >
                            {mode}
                          </Text>
                        </Box>
                      </Tooltip>
                    ))}
                  </Grid>
                  <FormHelperText>
                    {styles.mixBlendMode !== 'normal' &&
                      'Note: Blend modes may affect performance. Use with caution.'}
                  </FormHelperText>
                </FormControl>
              </Box>
            </VStack>
          </AccordionPanel>
        </AccordionItem>
      </Accordion>
    </VStack>
  );
};

const StyleSettings = ({ formData: { progressStyles, successStyles }, onChange }) => {
  const borderColor = useColorModeValue('gray.200', 'gray.600');
  const bgHover = useColorModeValue('gray.50', 'gray.700');
  const tabBg = useColorModeValue('white', 'gray.800');
  const activeBg = useColorModeValue('primary.50', 'gray.700');

  return (
    <Box
      borderWidth="1px"
      borderColor={borderColor}
      borderRadius="lg"
      p={6}
      _hover={{ bg: bgHover }}
      transition="background 0.2s"
    >
      <Text fontSize="lg" fontWeight="medium" mb={6}>
        Style Settings
        <Badge ml={2} colorScheme="primary" variant="subtle">
          Customize
        </Badge>
      </Text>

      <Tabs variant="enclosed" size="md">
        <TabList mb="4">
          <Tab
            key="progress-tab"
            _selected={{
              bg: activeBg,
              borderColor: borderColor,
              borderBottomColor: 'transparent'
            }}
          >
            Progress Message Style
          </Tab>
          <Tab
            key="success-tab"
            _selected={{
              bg: activeBg,
              borderColor: borderColor,
              borderBottomColor: 'transparent'
            }}
          >
            Success Message Style
          </Tab>
        </TabList>

        <TabPanels
          bg={tabBg}
          borderWidth="1px"
          borderColor={borderColor}
          borderRadius="md"
          p={4}
        >
          <TabPanel key="progress-panel">
            <StyleControls
              type="progress"
              styles={progressStyles}
              onChange={onChange}
            />
          </TabPanel>

          <TabPanel key="success-panel">
            <StyleControls
              type="success"
              styles={successStyles}
              onChange={onChange}
            />
          </TabPanel>
        </TabPanels>
      </Tabs>
    </Box>
  );
};

export default StyleSettings;