import {
  FormControl,
  FormLabel,
  Input,
  VStack,
  Text,
  Box,
  Badge,
  useColorModeValue,
  Icon,
  Tooltip,
  FormHelperText,
  Textarea,
  Flex,
  Switch
} from '@chakra-ui/react';
import { InfoIcon } from '@chakra-ui/icons';

const MessageSettings = ({ formData, onChange }) => {
  const helperTextColor = useColorModeValue('gray.600', 'gray.400');
  const borderColor = useColorModeValue('gray.200', 'gray.600');
  const bgHover = useColorModeValue('gray.50', 'gray.700');
  const isValidProgress = formData.progressMessage && formData.progressMessage.length >= 5;
  const isValidSuccess = formData.successMessage && formData.successMessage.length >= 5;

  return (
    <Box
      borderWidth="1px"
      borderColor={borderColor}
      borderRadius="lg"
      p={6}
      _hover={{ bg: bgHover }}
      transition="background 0.2s"
    >
      <VStack spacing={6} align="stretch">
        <Box>
          <Text fontSize="lg" fontWeight="medium" mb={4}>
            Message Settings
            <Badge
              ml={2}
              colorScheme={(isValidProgress && isValidSuccess) ? 'green' : 'orange'}
              variant="subtle"
            >
              {(isValidProgress && isValidSuccess) ? 'Complete' : 'Required'}
            </Badge>
          </Text>
        </Box>

        <FormControl isRequired>
          <FormLabel fontWeight="medium">
            Progress Message
            <Tooltip
              label="Message shown when cart total is below the minimum requirement"
              placement="top"
              hasArrow
            >
              <Icon as={InfoIcon} ml={2} color={helperTextColor} w={4} h={4} cursor="help" />
            </Tooltip>
          </FormLabel>
          <Textarea
            value={formData.progressMessage}
            onChange={e => onChange('progressMessage', e.target.value)}
            placeholder="Example: Add ${remaining} more to your cart to get ${discount} off!"
            size="md"
            rows={3}
            borderColor={borderColor}
            _hover={{ borderColor: 'primary.500' }}
            _focus={{
              borderColor: 'primary.500',
              boxShadow: '0 0 0 1px var(--chakra-colors-primary-500)'
            }}
          />
          <FormHelperText color={helperTextColor}>
            Use {'{remaining}'} for the amount needed and {'{discount}'} for the discount amount
          </FormHelperText>
          <FormHelperText color={helperTextColor} mt={1}>
            💡 Tip: Press Windows + . to open emoji picker
          </FormHelperText>
        </FormControl>

        <FormControl isRequired>
          <FormLabel fontWeight="medium">
            Success Message
            <Tooltip
              label="Message shown when the discount is applied"
              placement="top"
              hasArrow
            >
              <Icon as={InfoIcon} ml={2} color={helperTextColor} w={4} h={4} cursor="help" />
            </Tooltip>
          </FormLabel>
          <Textarea
            value={formData.successMessage}
            onChange={e => onChange('successMessage', e.target.value)}
            placeholder="Example: Congratulations! You've earned ${discount} off your order!"
            size="md"
            rows={3}
            borderColor={borderColor}
            _hover={{ borderColor: 'primary.500' }}
            _focus={{
              borderColor: 'primary.500',
              boxShadow: '0 0 0 1px var(--chakra-colors-primary-500)'
            }}
          />
          <FormHelperText color={helperTextColor}>
            Use {'{discount}'} to show the discount amount in your message
          </FormHelperText>
          <FormHelperText color={helperTextColor} mt={1}>
            💡 Tip: Press Windows + . to open emoji picker
          </FormHelperText>
        </FormControl>

      </VStack>
    </Box>
  );
};

export default MessageSettings;