import {
  FormControl,
  FormLabel,
  Input,
  VStack,
  Text,
  Box,
  useColorModeValue,
  InputGroup,
  InputRightElement,
  FormHelperText,
  Icon,
  Tooltip,
  Badge
} from '@chakra-ui/react';
import { InfoIcon, CheckIcon } from '@chakra-ui/icons';

const BasicDetails = ({ formData, onChange }) => {
  const helperTextColor = useColorModeValue('gray.600', 'gray.400');
  const borderColor = useColorModeValue('gray.200', 'gray.600');
  const bgHover = useColorModeValue('gray.50', 'gray.700');
  const isValidTitle = formData.title && formData.title.length >= 3;

  return (
    <Box
      borderWidth="1px"
      borderColor={borderColor}
      borderRadius="lg"
      p={6}
      _hover={{ bg: bgHover }}
      transition="background 0.2s"
    >
      <VStack spacing={6} align="stretch">
        <Box>
          <Text fontSize="lg" fontWeight="medium" mb={4}>
            Basic Details
            <Badge ml={2} colorScheme={isValidTitle ? 'green' : 'orange'} variant="subtle">
              {isValidTitle ? 'Complete' : 'Required'}
            </Badge>
          </Text>
        </Box>

        <FormControl isRequired>
          <FormLabel fontWeight="medium">
            Rule Name
            <Tooltip
              label="Enter a unique name to identify this discount rule"
              placement="top"
              hasArrow
            >
              <Icon as={InfoIcon} ml={2} color={helperTextColor} w={4} h={4} cursor="help" />
            </Tooltip>
          </FormLabel>
          <InputGroup>
            <Input
              value={formData.title}
              onChange={e => onChange('title', e.target.value)}
              placeholder="Enter a descriptive name (e.g. 'Summer Sale 20% Off')"
              size="md"
              pr="4.5rem"
              borderColor={borderColor}
              _hover={{ borderColor: 'primary.500' }}
              _focus={{
                borderColor: 'primary.500',
                boxShadow: '0 0 0 1px var(--chakra-colors-primary-500)'
              }}
            />
            {formData.title && (
              <InputRightElement>
                <Icon
                  as={CheckIcon}
                  color={isValidTitle ? 'green.500' : 'gray.300'}
                  w={4}
                  h={4}
                />
              </InputRightElement>
            )}
          </InputGroup>
          <FormHelperText color={helperTextColor}>
            {!formData.title
              ? 'Give your rule a clear, descriptive name'
              : !isValidTitle
                ? 'Name must be at least 3 characters long'
                : 'Great! This name will help you identify the rule later'}
          </FormHelperText>
        </FormControl>

      </VStack>
    </Box>
  );
};

export default BasicDetails;
