import { memo } from '@wordpress/element';
import { Modal } from '@wordpress/components';
import EditorForm from './EditorForm';
import { useRuleForm } from './useRuleForm';

const RuleEditor = memo(({ rule, onSave, onClose }) => {
  const {
    formData,
    handleChange,
    handleSave,
  } = useRuleForm(rule, onSave);

  return (
    <Modal
      title={rule ? 'Edit Rule' : 'Add New Rule'}
      onRequestClose={onClose}
      shouldCloseOnClickOutside={false}
      isDismissible={true}
      overlayClassName="dlift-modal-overlay"
      className="dlift-modal"
    >
      <div className="dlift-rule-editor">
        <EditorForm
          formData={formData}
          onChange={handleChange}
          onSave={handleSave}
          onCancel={onClose}
        />
      </div>
    </Modal>
  );
});

export default RuleEditor;