<?php

/**
 * Plugin Name: Smart Discount
 * Plugin URI: https://smartdiscount.logiklabs.tech
 * Description: Enhance your WooCommerce store with dynamic bulk discount features and real-time progress notifications to boost customer engagement and sales.
 * Version: 1.0.1
 * Author: LogikLabs
 * Author URI: https://logiklabs.tech
 * Text Domain: smart-discount
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.2
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

if (! defined('ABSPATH')) exit;

// Define plugin constants
define('DLift_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('DLift_PLUGIN_URL', plugins_url('/', __FILE__));
define('DLift_VERSION', '1.0.0');

// Load core files
require_once DLift_PLUGIN_PATH . 'includes/class-dlift-post-type.php';
require_once DLift_PLUGIN_PATH . 'includes/class-dlift-admin.php';
require_once DLift_PLUGIN_PATH . 'includes/class-dlift-frontend.php';
require_once DLift_PLUGIN_PATH . 'includes/class-dlift-rest-api.php';
require_once DLift_PLUGIN_PATH . 'includes/class-dlift-assets.php';
require_once DLift_PLUGIN_PATH . 'includes/class-smart-discount-tracking.php';
require_once DLift_PLUGIN_PATH . 'includes/class-smart-discount-consent-modal.php';


/**
 * Main plugin class
 */
class SmartDiscountForWoocommerce
{
  /**
   * Constructor
   */
  public function __construct()
  {
    // Initialize components
    new DLift_Post_Type();
    new DLift_Admin();
    new DLift_Frontend();
    new DLift_Rest_API();
    new DLift_Assets();

    // Initialize tracking and consent
    if (is_admin()) {
      Smart_Discount_Consent_Modal::get_instance();
      Smart_Discount_Tracking::get_instance();
    }
  }
}

// Initialize the plugin
function dlift_init()
{
  // Load translations
  load_plugin_textdomain('smart-discount', false, dirname(plugin_basename(__FILE__)) . '/languages');

  new SmartDiscountForWoocommerce();
}
add_action('plugins_loaded', 'dlift_init');

// Activation hook
register_activation_hook(__FILE__, 'smart_discount_activation');

function smart_discount_activation()
{
  // Reset tracking options on activation
  delete_option('smart_discount_tracking_consent');
  delete_option('smart_discount_tracking_consent_shown');
  delete_option('smart_discount_installation_tracked');
}
