<?php

/**
 * Enhanced Consent Modal Template
 *
 * @package SmartDiscount
 * @since 1.0.0
 */

defined('ABSPATH') || exit;
?>

<div id="smart-discount-consent-modal" class="smart-discount-modal" style="display: none;">
  <div class="smart-discount-modal-content">
    <!-- Header -->
    <div class="modal-header">
      <div class="logo-title-wrapper">
        <img src="<?php echo esc_url(DLift_PLUGIN_URL . 'assets/images/logo.svg'); ?>" alt="Smart Discount" width="32" height="32" />
        <h2><?php esc_html_e('Help Us Improve Smart Discount', 'smart-discount'); ?></h2>
      </div>
    </div>

    <!-- Body -->
    <div class="modal-body">
      <div class="consent-benefits">
        <div class="benefit-item">
          <span class="benefit-icon">📊</span>
          <span class="benefit-text">
            <?php esc_html_e('Get a better plugin tailored to YOUR needs', 'smart-discount'); ?>
          </span>
        </div>
        <div class="benefit-item">
          <span class="benefit-icon">🛡️</span>
          <span class="benefit-text">
            <?php esc_html_e('Only anonymous data - your privacy is protected', 'smart-discount'); ?>
          </span>
        </div>
      </div>
    </div>

    <!-- Footer -->
    <div class="modal-footer">
      <button type="button" id="smart-discount-consent-yes" class="button button-primary">
        <?php esc_html_e('Yes, count me in!', 'smart-discount'); ?>
      </button>
      <button type="button" id="smart-discount-consent-no" class="button button-secondary">
        <?php esc_html_e('Skip', 'smart-discount'); ?>
      </button>
    </div>
  </div>
</div>