<?php

/**
 * GA4 Consent Modal Template
 *
 * @package SmartDiscount
 * @since 1.0.0
 */

defined('ABSPATH') || exit;
?>

<div id="smart-discount-consent-modal" class="smart-discount-modal" style="display: none;">
  <div class="smart-discount-modal-content">
    <h2><?php esc_html_e('Analytics Consent', 'smart-discount'); ?></h2>

    <p>
      <?php esc_html_e('We would like to collect anonymous usage data to improve our plugin. This data includes your site URL and basic installation information. No personal data will be collected.', 'smart-discount'); ?>
    </p>

    <div class="smart-discount-modal-buttons">
      <button type="button" class="button button-primary" id="smart-discount-consent-yes">
        <?php esc_html_e('Accept', 'smart-discount'); ?>
      </button>
      <button type="button" class="button" id="smart-discount-consent-no">
        <?php esc_html_e('Decline', 'smart-discount'); ?>
      </button>
    </div>
  </div>
</div>

<style>
  .smart-discount-modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    z-index: 100000;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .smart-discount-modal-content {
    background: #fff;
    padding: 30px;
    border-radius: 5px;
    max-width: 500px;
    width: 90%;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
  }

  .smart-discount-modal-buttons {
    margin-top: 20px;
    text-align: right;
  }

  .smart-discount-modal-buttons button {
    margin-left: 10px;
  }
</style>

<script>
  jQuery(document).ready(function($) {
    function handleConsent(consent) {
      $.ajax({
        url: ajaxurl,
        type: 'POST',
        data: {
          action: 'smart_discount_track_consent',
          consent: consent,
          nonce: '<?php echo wp_create_nonce('smart_discount_tracking_nonce'); ?>'
        },
        success: function(response) {
          $('#smart-discount-consent-modal').hide();
        },
        error: function(xhr, status, error) {
          console.error('Error saving consent:', error);
        }
      });
    }

    $('#smart-discount-consent-yes').on('click', function() {
      handleConsent('yes');
    });

    $('#smart-discount-consent-no').on('click', function() {
      handleConsent('no');
    });
  });
</script>