<?php

/**
 * Consent Modal Implementation
 */
class Smart_Discount_Consent_Modal
{
  private static $instance = null;

  public static function get_instance()
  {
    if (null === self::$instance) {
      self::$instance = new self();
    }
    return self::$instance;
  }

  private function __construct()
  {
    add_action('admin_enqueue_scripts', array($this, 'enqueue_modal_assets'));
    add_action('admin_footer', array($this, 'render_modal'));
  }

  public function enqueue_modal_assets()
  {
    if (!$this->should_show_modal()) {
      return;
    }

    wp_enqueue_style(
      'smart-discount-consent-modal',
      DLift_PLUGIN_URL . 'assets/css/consent-modal.css',
      array(),
      DLift_VERSION
    );

    wp_enqueue_script(
      'smart-discount-consent-modal',
      DLift_PLUGIN_URL . 'assets/js/consent-modal.js',
      array('jquery'),
      DLift_VERSION,
      true
    );

    wp_localize_script('smart-discount-consent-modal', 'smartDiscountConsent', array(
      'ajaxurl' => admin_url('admin-ajax.php'),
      'nonce' => wp_create_nonce('smart_discount_nonce'),
      'i18n' => array(
        'success' => __('Thank you for helping us improve Smart Discount!', 'smart-discount'),
        'error' => __('An error occurred. Please try again.', 'smart-discount')
      )
    ));
  }

  public function render_modal()
  {
    if (!$this->should_show_modal()) {
      return;
    }
?>
    <div id="smart-discount-consent-modal" class="smart-discount-modal">
      <div class="smart-discount-modal-content">
        <div class="modal-header">
          <div class="logo-title-wrapper">
            <h2><?php _e('Help Us Improve Smart Discount', 'smart-discount'); ?></h2>
          </div>
        </div>
        <div class="modal-body">
          <div class="consent-benefits">
            <div class="benefit-item">
              <span class="benefit-icon">📈</span>
              <span class="benefit-text"><?php _e('Get a better plugin tailored to YOUR needs', 'smart-discount'); ?></span>
            </div>
            <div class="benefit-item">
              <span class="benefit-icon">🛡️</span>
              <span class="benefit-text"><?php _e('Only anonymous data - your privacy is protected', 'smart-discount'); ?></span>
            </div>
            <div class="benefit-item">
              <span class="benefit-icon">🚀</span>
              <span class="benefit-text"><?php _e('Help us improve your discount experience', 'smart-discount'); ?></span>
            </div>
          </div>
        </div>
        <div class="modal-footer">
          <button type="button" id="smart-discount-consent-yes" class="button button-primary">
            <?php _e('Yes, count me in!', 'smart-discount'); ?>
          </button>
          <button type="button" id="smart-discount-consent-no" class="button button-secondary">
            <?php _e('Skip', 'smart-discount'); ?>
          </button>
        </div>
      </div>
    </div>
<?php
  }

  private function should_show_modal()
  {
    if (!is_admin()) {
      return false;
    }

    $screen = get_current_screen();
    if (!$screen || !in_array($screen->id, array('plugins', 'toplevel_page_smart-discount'))) {
      return false;
    }

    return get_option('smart_discount_tracking_consent_shown', 'pending') === 'pending';
  }
}
