<?php

if (! defined('ABSPATH')) exit;

/**
 * Post Type Handler
 */
class DLift_Post_Type
{
  /**
   * Constructor
   */
  public function __construct()
  {
    add_action('init', array($this, 'dlift_register_post_type'));
  }

  /**
   * Register the discount rule post type and meta fields
   */
  public function dlift_register_post_type()
  {
    register_post_type('dlift_discount_rule', array(
      'labels' => array(
        'name' => __('Discount Rules', 'smart-discount'),
        'singular_name' => __('Discount Rule', 'smart-discount'),
      ),
      'public' => false,
      'show_ui' => false,
      'show_in_menu' => false,
      'supports' => array('title', 'custom-fields'),
      'show_in_rest' => true,
      'rest_base' => 'dlift_discount_rule',
      'rest_controller_class' => 'WP_REST_Posts_Controller',
      'capability_type' => 'post',
      'capabilities' => array(
        'create_posts' => 'manage_options',
        'edit_post' => 'manage_options',
        'edit_posts' => 'manage_options',
        'edit_others_posts' => 'manage_options',
        'delete_post' => 'manage_options',
        'delete_posts' => 'manage_options',
        'read_post' => 'manage_options',
        'read_private_posts' => 'manage_options',
        'publish_posts' => 'manage_options',
      ),
    ));

    $this->register_meta_fields();
  }

  /**
   * Register meta fields for the discount rule post type
   */
  private function register_meta_fields()
  {
    // Register meta fields
    $meta_fields = array(
      'dlift_condition_value' => array(
        'type' => 'number',
        'description' => __('Value for the condition', 'smart-discount'),
        'default' => 0,
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function () {
          return current_user_can('manage_options');
        },
      ),
      'dlift_discount_type' => array(
        'type' => 'string',
        'description' => __('Type of discount', 'smart-discount'),
        'default' => 'percentage',
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function () {
          return current_user_can('manage_options');
        },
      ),
      'dlift_discount_value' => array(
        'type' => 'number',
        'description' => __('Value of the discount', 'smart-discount'),
        'default' => 0,
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function () {
          return current_user_can('manage_options');
        },
      ),
      'dlift_celebration_type' => array(
        'type' => 'string',
        'description' => __('Type of celebration animation', 'smart-discount'),
        'default' => 'none',
        'single' => true,
        'show_in_rest' => true,
        'sanitize_callback' => function ($value) {
          $valid_types = array(
            'none',
            'basic',
            'fireworks',
            'sparkles',
            'party',
            'rainbow',
            'stars',
            'hearts',
            'glitter',
            'explosion',
            'snow',
            'bubbles'
          );
          return in_array($value, $valid_types) ? $value : 'none';
        },
        'auth_callback' => function () {
          return current_user_can('manage_options');
        },
      ),
      'dlift_progress_message' => array(
        'type' => 'string',
        'description' => __('Message to display when below threshold', 'smart-discount'),
        'default' => __('Spend {remaining_amount} more to get {discount} off!', 'smart-discount'),
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function () {
          return current_user_can('manage_options');
        },
      ),
      'dlift_success_message' => array(
        'type' => 'string',
        'description' => __('Message to display when threshold is met', 'smart-discount'),
        'default' => __('Congratulations! You\'ve unlocked {discount} off your order!', 'smart-discount'),
        'single' => true,
        'show_in_rest' => true,
        'auth_callback' => function () {
          return current_user_can('manage_options');
        },
      ),
      'dlift_progress_styles' => array(
        'type' => 'object',
        'description' => __('Styles for the progress message', 'smart-discount'),
        'default' => array(
          'padding' => 16,
          'backgroundColor' => '#f0f0f1',
          'textColor' => '#1e1e1e',
          'borderColor' => '#ddd',
          'borderWidth' => 1,
          'borderRadius' => 4,
        ),
        'single' => true,
        'show_in_rest' => array(
          'schema' => array(
            'type' => 'object',
            'properties' => array(
              'padding' => array('type' => 'number'),
              'paddingTop' => array('type' => 'number'),
              'paddingRight' => array('type' => 'number'),
              'paddingBottom' => array('type' => 'number'),
              'paddingLeft' => array('type' => 'number'),
              'backgroundColor' => array('type' => 'string'),
              'textColor' => array('type' => 'string'),
              'borderColor' => array('type' => 'string'),
              'borderWidth' => array('type' => 'number'),
              'borderStyle' => array('type' => 'string'),
              'borderRadius' => array('type' => 'number'),
              'fontSize' => array('type' => 'number'),
              'fontWeight' => array('type' => 'string'),
              'lineHeight' => array('type' => 'number'),
              'letterSpacing' => array('type' => 'number'),
              'textAlign' => array('type' => 'string'),
              'textDecoration' => array('type' => 'string'),
              'textTransform' => array('type' => 'string'),
              'boxShadowX' => array('type' => 'number'),
              'boxShadowY' => array('type' => 'number'),
              'boxShadowBlur' => array('type' => 'number'),
              'boxShadowSpread' => array('type' => 'number'),
              'boxShadowColor' => array('type' => 'string'),
              'textShadowX' => array('type' => 'number'),
              'textShadowY' => array('type' => 'number'),
              'textShadowBlur' => array('type' => 'number'),
              'textShadowColor' => array('type' => 'string'),
              'scaleX' => array('type' => 'number'),
              'scaleY' => array('type' => 'number'),
              'rotate' => array('type' => 'number'),
              'translateX' => array('type' => 'number'),
              'translateY' => array('type' => 'number'),
              'skewX' => array('type' => 'number'),
              'skewY' => array('type' => 'number'),
              'transformOrigin' => array('type' => 'string'),
              'blur' => array('type' => 'number'),
              'brightness' => array('type' => 'number'),
              'contrast' => array('type' => 'number'),
              'saturation' => array('type' => 'number'),
              'hue' => array('type' => 'number'),
              'opacity' => array('type' => 'number'),
              'backdropBlur' => array('type' => 'number'),
              'backdropBrightness' => array('type' => 'number'),
              'backdropContrast' => array('type' => 'number'),
              'backdropSaturation' => array('type' => 'number'),
              'backdropOpacity' => array('type' => 'number'),
              'mixBlendMode' => array('type' => 'string'),
              'backgroundOpacity' => array('type' => 'number'),
              'textOpacity' => array('type' => 'number')
            ),
            'additionalProperties' => false
          ),
        ),
        'auth_callback' => function () {
          return current_user_can('manage_options');
        },
      ),
      'dlift_success_styles' => array(
        'type' => 'object',
        'description' => __('Styles for the success message', 'smart-discount'),
        'default' => array(
          'padding' => 16,
          'backgroundColor' => '#edfaef',
          'textColor' => '#1e1e1e',
          'borderColor' => '#4ab866',
          'borderWidth' => 1,
          'borderRadius' => 4,
        ),
        'single' => true,
        'show_in_rest' => array(
          'schema' => array(
            'type' => 'object',
            'properties' => array(
              'padding' => array('type' => 'number'),
              'paddingTop' => array('type' => 'number'),
              'paddingRight' => array('type' => 'number'),
              'paddingBottom' => array('type' => 'number'),
              'paddingLeft' => array('type' => 'number'),
              'backgroundColor' => array('type' => 'string'),
              'textColor' => array('type' => 'string'),
              'borderColor' => array('type' => 'string'),
              'borderWidth' => array('type' => 'number'),
              'borderStyle' => array('type' => 'string'),
              'borderRadius' => array('type' => 'number'),
              'fontSize' => array('type' => 'number'),
              'fontWeight' => array('type' => 'string'),
              'lineHeight' => array('type' => 'number'),
              'letterSpacing' => array('type' => 'number'),
              'textAlign' => array('type' => 'string'),
              'textDecoration' => array('type' => 'string'),
              'textTransform' => array('type' => 'string'),
              'boxShadowX' => array('type' => 'number'),
              'boxShadowY' => array('type' => 'number'),
              'boxShadowBlur' => array('type' => 'number'),
              'boxShadowSpread' => array('type' => 'number'),
              'boxShadowColor' => array('type' => 'string'),
              'textShadowX' => array('type' => 'number'),
              'textShadowY' => array('type' => 'number'),
              'textShadowBlur' => array('type' => 'number'),
              'textShadowColor' => array('type' => 'string'),
              'scaleX' => array('type' => 'number'),
              'scaleY' => array('type' => 'number'),
              'rotate' => array('type' => 'number'),
              'translateX' => array('type' => 'number'),
              'translateY' => array('type' => 'number'),
              'skewX' => array('type' => 'number'),
              'skewY' => array('type' => 'number'),
              'transformOrigin' => array('type' => 'string'),
              'blur' => array('type' => 'number'),
              'brightness' => array('type' => 'number'),
              'contrast' => array('type' => 'number'),
              'saturation' => array('type' => 'number'),
              'hue' => array('type' => 'number'),
              'opacity' => array('type' => 'number'),
              'backdropBlur' => array('type' => 'number'),
              'backdropBrightness' => array('type' => 'number'),
              'backdropContrast' => array('type' => 'number'),
              'backdropSaturation' => array('type' => 'number'),
              'backdropOpacity' => array('type' => 'number'),
              'mixBlendMode' => array('type' => 'string'),
              'backgroundOpacity' => array('type' => 'number'),
              'textOpacity' => array('type' => 'number')
            ),
            'additionalProperties' => false
          ),
        ),
        'auth_callback' => function () {
          return current_user_can('manage_options');
        },
      ),
    );

    foreach ($meta_fields as $key => $field) {
      register_post_meta('dlift_discount_rule', $key, $field);
    }

    register_post_meta('dlift_discount_rule', 'progressStyles', array(
      'type' => 'object',
      'single' => true,
      'show_in_rest' => array(
        'schema' => array(
          'type' => 'object',
          'properties' => array(
            'backgroundOpacity' => array(
              'type' => 'number',
              'default' => 1
            ),
            'textOpacity' => array(
              'type' => 'number',
              'default' => 1
            ),
          )
        )
      )
    ));

    register_post_meta('dlift_discount_rule', 'successStyles', array(
      'type' => 'object',
      'single' => true,
      'show_in_rest' => array(
        'schema' => array(
          'type' => 'object',
          'properties' => array(
            'backgroundOpacity' => array(
              'type' => 'number',
              'default' => 1
            ),
            'textOpacity' => array(
              'type' => 'number',
              'default' => 1
            ),
          )
        )
      )
    ));

    register_post_meta('dlift_discount_rule', 'scaleX', array(
      'type' => 'number',
      'single' => true,
      'show_in_rest' => true,
      'default' => 1
    ));

    register_post_meta('dlift_discount_rule', 'scaleY', array(
      'type' => 'number',
      'single' => true,
      'show_in_rest' => true,
      'default' => 1
    ));

    register_post_meta('dlift_discount_rule', 'rotate', array(
      'type' => 'number',
      'single' => true,
      'show_in_rest' => true,
      'default' => 0
    ));

    register_post_meta('dlift_discount_rule', 'translateX', array(
      'type' => 'number',
      'single' => true,
      'show_in_rest' => true,
      'default' => 0
    ));

    register_post_meta('dlift_discount_rule', 'translateY', array(
      'type' => 'number',
      'single' => true,
      'show_in_rest' => true,
      'default' => 0
    ));

    register_post_meta('dlift_discount_rule', 'skewX', array(
      'type' => 'number',
      'single' => true,
      'show_in_rest' => true,
      'default' => 0
    ));

    register_post_meta('dlift_discount_rule', 'skewY', array(
      'type' => 'number',
      'single' => true,
      'show_in_rest' => true,
      'default' => 0
    ));

    register_post_meta('dlift_discount_rule', 'transformOrigin', array(
      'type' => 'string',
      'single' => true,
      'show_in_rest' => true,
      'default' => 'center'
    ));
  }
}
