<?php

if (! defined('ABSPATH')) exit;

/**
 * Admin Handler
 */
class DLift_Admin
{
  /**
   * Constructor
   */
  public function __construct()
  {
    add_action('admin_menu', array($this, 'dlift_add_admin_menu'));
    add_action('admin_enqueue_scripts', array($this, 'dlift_enqueue_admin_assets'));
  }

  /**
   * Add admin menu item
   */
  public function dlift_add_admin_menu()
  {
    add_menu_page(
      'Discount Rules',
      'Discount Rules',
      'manage_options',
      'discountlift',
      array($this, 'dlift_render_admin_page'),
      'dashicons-tickets-alt',
      30
    );
  }

  /**
   * Render admin page
   */
  public function dlift_render_admin_page()
  {
    echo '<div class="wrap"><div id="discountlift-app"></div></div>';
  }

  /**
   * Enqueue admin assets
   */
  public function dlift_enqueue_admin_assets($hook)
  {
    if ('toplevel_page_discountlift' !== $hook) {
      return;
    }

    $asset_file = DLift_PLUGIN_PATH . 'build/index.asset.php';
    if (file_exists($asset_file)) {
      $asset = include($asset_file);

      wp_enqueue_script(
        'discountlift-admin',
        DLift_PLUGIN_URL . 'build/index.js',
        $asset['dependencies'],
        $asset['version'],
        true
      );

      wp_enqueue_style(
        'discountlift-admin-style',
        DLift_PLUGIN_URL . 'build/index.css',
        array(),
        $asset['version']
      );
    }
  }
}
