const fs = require('fs');
const path = require('path');

// Directory to clean
const buildDir = path.join(__dirname, 'build');

// Files to keep
const keepFiles = [
  'index.js',
  'frontend.js',
  'index.css'
];

// Clean build directory
fs.readdir(buildDir, (err, files) => {
  if (err) throw err;

  files.forEach(file => {
    if (!keepFiles.includes(file)) {
      fs.unlink(path.join(buildDir, file), err => {
        if (err) throw err;
      });
    }
  });
});