<?php
/*
Plugin Name: Smart 404 Redirect Manager
Plugin URI:  https://wordpress.org/plugins/smart-404-redirect-manager/
Description: Smart 404 Redirect & Log Manager helps you automatically manage 404 errors, create smart redirects, prevent loops, and maintain SEO health — all with a clean admin interface.
Version:     1.0.1
Author:      Aman Brar
Author URI:  https://profiles.wordpress.org/amandeepwebspero/
License:     GPL2+
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: smart-404-redirect-manager
*/

if ( ! defined( 'ABSPATH' ) ) exit;

define('S4RM_DIR', plugin_dir_path(__FILE__));
define('S4RM_URL', plugin_dir_url(__FILE__));
define('S4RM_VERSION', '1.0.1');

register_activation_hook(__FILE__, 's4rm_activate');
register_deactivation_hook(__FILE__, 's4rm_deactivate');

function s4rm_activate() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $table_logs = $wpdb->prefix . 's4rm_404_logs';
    $table_rules = $wpdb->prefix . 's4rm_redirect_rules';
    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

    $sql = "CREATE TABLE IF NOT EXISTS {$table_logs} (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        request_uri TEXT NOT NULL,
        referrer TEXT,
        user_agent TEXT,
        ip VARCHAR(45),
        hits BIGINT(20) UNSIGNED DEFAULT 1,
        first_seen DATETIME,
        last_seen DATETIME,
        PRIMARY KEY (id)
    ) {$charset_collate};";
    dbDelta( $sql );

    $sql2 = "CREATE TABLE IF NOT EXISTS {$table_rules} (
        id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
        old_path TEXT NOT NULL,
        new_url TEXT NOT NULL,
        type VARCHAR(10) DEFAULT '301',
        created_at DATETIME,
        PRIMARY KEY (id)
    ) {$charset_collate};";
    dbDelta( $sql2 );

    // default options
    add_option('s4rm_global_redirect_enabled', '0');
    add_option('s4rm_redirect_url', home_url('/'));
    add_option('s4rm_redirect_type', '301');
    add_option('s4rm_excluded_urls', '');
    add_option('s4rm_loop_threshold', 5); // max redirects per minute per IP
}

function s4rm_deactivate() {
    // Keep data for reuse. Do not drop tables.
}

// load includes
require_once S4RM_DIR . 'includes/redirect-handler.php';
if ( is_admin() ) {
    require_once S4RM_DIR . 'includes/admin.php';
}
