<?php
if ( ! defined( 'ABSPATH' ) ) exit;
global $wpdb;

add_action('template_redirect', 's4rm_handle_404', 0);

function s4rm_handle_404() {
    if ( ! is_404() ) return;

    // loop protection: limit redirects per IP per minute
    $ip = isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field($_SERVER['REMOTE_ADDR']) : 'unknown';
    $key = 's4rm_rct_' . md5($ip);
    $count = (int) get_transient($key);
    $threshold = (int) get_option('s4rm_loop_threshold', 5);
    if ( $count >= $threshold ) {
        // too many redirects from this IP recently, skip redirect to avoid loops/abuse
        return;
    }

    // check rules first (exact match)
    $uri = ( isset($_SERVER['REQUEST_URI']) ? wp_unslash( $_SERVER['REQUEST_URI'] ) : '' );
    $uri = strtok( $uri, '?' ); // remove query
    $uri = trim( $uri );
    global $wpdb;
    $table_rules = $wpdb->prefix . 's4rm_redirect_rules';
    $row = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM {$table_rules} WHERE old_path = %s LIMIT 1", $uri ) );

    if ( $row ) {
        $new = esc_url_raw( $row->new_url );
        $type = ( $row->type === '302' ) ? 302 : 301;
        // increment transient counter
        set_transient( $key, $count + 1, 60 );
        wp_safe_redirect( $new, $type );
        exit;
    }

    // Log the 404
    s4rm_log_404( $uri );

    // If global redirect enabled, perform redirect to specified URL
    if ( get_option('s4rm_global_redirect_enabled', '0') == '1' ) {
        $exclusions = s4rm_get_exclusions();
        foreach ( $exclusions as $pattern ) {
            if ( empty($pattern) ) continue;
            // simple contains or exact
            if ( strpos( $uri, trim($pattern) ) !== false ) {
                return; // excluded
            }
        }
        $target = esc_url_raw( get_option('s4rm_redirect_url', home_url('/') ) );
        $rtype = ( get_option('s4rm_redirect_type', '301') === '302' ) ? 302 : 301;
        set_transient( $key, $count + 1, 60 );
        wp_safe_redirect( $target, $rtype );
        exit;
    }
}

function s4rm_log_404( $uri ) {
    global $wpdb;
    $table = $wpdb->prefix . 's4rm_404_logs';
    $ip = isset($_SERVER['REMOTE_ADDR']) ? sanitize_text_field($_SERVER['REMOTE_ADDR']) : '';
    $ref = isset($_SERVER['HTTP_REFERER']) ? esc_url_raw( wp_unslash( $_SERVER['HTTP_REFERER'] ) ) : '';
    $ua = isset($_SERVER['HTTP_USER_AGENT']) ? sanitize_text_field( $_SERVER['HTTP_USER_AGENT'] ) : '';
    $now = current_time('mysql');

    // try update existing row by exact request_uri match
    $existing = $wpdb->get_row( $wpdb->prepare( "SELECT * FROM {$table} WHERE request_uri = %s LIMIT 1", $uri ) );
    if ( $existing ) {
        $wpdb->update( 
            $table,
            array( 'hits' => $existing->hits + 1, 'last_seen' => $now ),
            array( 'id' => $existing->id ),
            array( '%d', '%s' ),
            array( '%d' )
        );
    } else {
        $wpdb->insert( 
            $table, 
            array(
                'request_uri' => $uri,
                'referrer' => $ref,
                'user_agent' => $ua,
                'ip' => $ip,
                'hits' => 1,
                'first_seen' => $now,
                'last_seen' => $now
            ), 
            array( '%s','%s','%s','%s','%d','%s','%s' ) 
        );
    }
}

function s4rm_get_exclusions() {
    $raw = get_option('s4rm_excluded_urls', '');
    // allow line breaks or comma separated
    $raw = str_replace( array("\r\n","\r"), "\n", $raw );
    $parts = preg_split('/[\n,]+/', $raw);
    $parts = array_map('trim', $parts);
    return array_filter($parts);
}
