<?php

/**
 * Plugin Name: SlideMotion
 * Description: SlideMotion is an Elementor slider widget that allows you to create responsive, customizable sliders with images, icons, and content using drag-and-drop controls.
 * Version: 1.1.0
 * Author: Triveni Global Software
 * Author URI: https://triveniglobalsoft.com/
 * License: GPL2+
 * Text Domain: slidemotion
 */



defined('ABSPATH') || exit;
define('SLIDEMOTION_VERSION', '1.0.0');
define('SLIDEMOTION_PLUGIN_URL', plugin_dir_url(__FILE__));

// Elementor dependency check
function slidemotion_init_plugin() {
    // Check if Elementor is loaded
    if ( ! did_action('elementor/loaded') ) {
        add_action('admin_notices', 'slidemotion_elementor_missing_notice');
        return;
    }
    // Register widget only if Elementor is loaded
    add_action('elementor/widgets/register', 'slidemotion_register_widget');
}
add_action('plugins_loaded', 'slidemotion_init_plugin');

// Admin notice if Elementor is missing
function slidemotion_elementor_missing_notice() {
    if ( ! current_user_can('activate_plugins') ) {
        return;
    }
    echo '<div class="notice notice-error"><p>';
    echo esc_html__('SlideMotion Slider requires Elementor to be installed and activated.', 'slidemotion');
    echo '</p></div>';
}


/**
 * Register Elementor widget
 */
function slidemotion_register_widget($widgets_manager)
{

    require_once plugin_dir_path(__FILE__) . 'includes/class-slidemotion-widget.php';

    $widgets_manager->register(new \Slidemotion_Widget());
}


/**
 * Enqueue frontend assets
 */
function slidemotion_enqueue_assets()
{

    wp_enqueue_script('slick-js',SLIDEMOTION_PLUGIN_URL . 'assets/js/slick.min.js',array('jquery'),'1.8.1',true);

    wp_enqueue_script(
        'slidemotion-slider-js',SLIDEMOTION_PLUGIN_URL . 'assets/js/slidemotion-slider.js',array('jquery'),SLIDEMOTION_VERSION,true);

    wp_enqueue_script('cm-editor-slider',SLIDEMOTION_PLUGIN_URL . 'assets/js/editor-slider.js',array('jquery', 'slick-js'),'1.1.0', true);

    wp_enqueue_style('slick-css',SLIDEMOTION_PLUGIN_URL . 'assets/css/slick.css',array(),'1.8.1');

    wp_enqueue_style('slick-css-theme',SLIDEMOTION_PLUGIN_URL . 'assets/css/slick-theme.css',array(),'1.8.1');

    wp_enqueue_style('slidemotion-slider-css',SLIDEMOTION_PLUGIN_URL . 'assets/css/slidemotion-slider.css',array(),SLIDEMOTION_VERSION);
}

add_action('wp_enqueue_scripts', 'slidemotion_enqueue_assets');
