<?php

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}


class Slidemotion_Widget extends \Elementor\Widget_Base
{

    public function get_name(): string
    {
        return 'slidemotion';
    }

    public function get_title(): string
    {
        return esc_html__('SlideMotion', 'slidemotion');
    }

    public function get_icon(): string
    {
        return 'eicon-slider-3d';
    }

    public function get_categories(): array
    {
        return ['general'];
    }

    public function get_keywords(): array
    {
        return ['slider', 'carousel'];
    }

    protected function register_controls(): void
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'slidemotion'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $cm_repeater = new \Elementor\Repeater();

        // Type Dropdown

        $cm_repeater->add_control(
            'list_title',
            [
                'label' => esc_html__('Title', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('List Title', 'slidemotion'),
                'label_block' => true,
            ]
        );

        // Image or Icon Chooser
        $cm_repeater->add_control(
            'media_type',
            [
                'label' => __('Image or Icon', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'none' => [
                        'title' => __('None', 'slidemotion'),
                        'icon' => 'eicon-ban',
                    ],
                    'icon' => [
                        'title' => __('Icon', 'slidemotion'),
                        'icon' => 'eicon-info-circle',
                    ],
                    'image' => [
                        'title' => __('Image', 'slidemotion'),
                        'icon' => 'eicon-image',
                    ],
                ],
                'default' => 'none',
                'toggle' => false,
            ]
        );

        // Icon Picker (conditionally shown)
        $cm_repeater->add_control(
            'selected_icon',
            [
                'label' => __('Icon', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition' => [
                    'media_type' => 'icon',
                ],
            ]
        );


        // Image Upload (conditionally shown)
        $cm_repeater->add_control(
            'selected_image',
            [
                'label' => __('Image', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'media_types' => ['image'],
                'condition' => [
                    'media_type' => 'image',
                ],
            ]
        );


        // WYSIWYG Content Editor
        $cm_repeater->add_control(
            'content_text',
            [
                'label' => __('Content', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::WYSIWYG,
                'default' => __('Write your content here...', 'slidemotion'),
            ]
        );

        $this->add_control(
            'image_icon_items',
            [
                'label' => esc_html__('Slider Items', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $cm_repeater->get_controls(),

                // 👇 DEFAULT ITEMS HERE
                'default' => [
                    [
                        'list_title'   => esc_html__('First Slide', 'slidemotion'),
                        'type'         => 'image_icon_top',
                        'media_type'   => 'icon',
                        'content_text' => esc_html__('This is the first slide content.', 'slidemotion'),
                        'selected_icon' => [
                            'value' => 'fas fa-star',
                            'library' => 'fa-solid',
                        ],
                    ],
                    [
                        'list_title'   => esc_html__('Second Slide', 'slidemotion'),
                        'type'         => 'image_icon_top',
                        'media_type'   => 'icon',
                        'content_text' => esc_html__('This is the second slide content.', 'slidemotion'),
                        'selected_icon' => [
                            'value' => 'fas fa-star',
                            'library' => 'fa-solid',
                        ],
                    ],
                ],

                // Text shown in editor list
                'title_field' => '{{{ list_title }}}',
            ]
        );


        $this->add_control(
            'type',
            [
                'label' => __('Type', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image_icon_top',
                'options' => [
                    'image_icon_top' => __('Image/Icon On Top', 'slidemotion'),
                    'image_icon_left' => __('Image/Icon On Left', 'slidemotion'),
                    'image_icon_right' => __('Image/Icon On Right', 'slidemotion'),
                ],
            ]
        );

        // Icon Position --- START
        $this->add_control(
            'icon_vertical_position',
            [
                'label' => __('Icon/Image Alignment', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'cm-position-start' => [
                        'title' => __('Left / Top', 'slidemotion'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'cm-position-center' => [
                        'title' => __('Center', 'slidemotion'),
                        'icon' => 'eicon-h-align-center',
                    ],
                    'cm-position-end' => [
                        'title' => __('Right / Bottom', 'slidemotion'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => 'cm-position-start',
            ]
        );


        // Icon Position --- END


        $this->add_control(
            'slides_to_show',
            [
                'label' => esc_html__('Slides To Show', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('1', 'slidemotion'),
                    '2' => esc_html__('2', 'slidemotion'),
                    '3'  => esc_html__('3', 'slidemotion'),
                    '4' => esc_html__('4', 'slidemotion'),
                    '5' => esc_html__('5', 'slidemotion'),
                ],
            ]
        );

        $this->add_control(
            'slides_to_scroll',
            [
                'label' => esc_html__('Slides To Scroll', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('1', 'slidemotion'),
                    '2' => esc_html__('2', 'slidemotion'),
                    '3'  => esc_html__('3', 'slidemotion'),
                    '4' => esc_html__('4', 'slidemotion'),
                    '5' => esc_html__('5', 'slidemotion'),
                ],
            ]
        );


        $this->add_control(
            'tablet',
            [
                'label' => esc_html__('Tablet', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'tablet_slides_to_show',
            [
                'label' => esc_html__('Tablet Slides To Show', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('1', 'slidemotion'),
                    '2' => esc_html__('2', 'slidemotion'),
                    '3'  => esc_html__('3', 'slidemotion'),
                    '4' => esc_html__('4', 'slidemotion'),
                    '5' => esc_html__('5', 'slidemotion'),
                ],
            ]
        );

        $this->add_control(
            'tablet_slides_to_scroll',
            [
                'label' => esc_html__('Tablet Slides To Scroll', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('1', 'slidemotion'),
                    '2' => esc_html__('2', 'slidemotion'),
                    '3'  => esc_html__('3', 'slidemotion'),
                    '4' => esc_html__('4', 'slidemotion'),
                    '5' => esc_html__('5', 'slidemotion'),
                ],
            ]
        );



        $this->add_control(
            'mobile',
            [
                'label' => esc_html__('Mobile', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'mobo_slides_to_show',
            [
                'label' => esc_html__('Mobile Slides To Show', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('1', 'slidemotion'),
                    '2' => esc_html__('2', 'slidemotion'),
                    '3'  => esc_html__('3', 'slidemotion'),
                    '4' => esc_html__('4', 'slidemotion'),
                    '5' => esc_html__('5', 'slidemotion'),
                ],
            ]
        );
        $this->add_control(
            'mobo_slides_to_scroll',
            [
                'label' => esc_html__('Mobile Slides To Scroll', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
                    '1' => esc_html__('1', 'slidemotion'),
                    '2' => esc_html__('2', 'slidemotion'),
                    '3'  => esc_html__('3', 'slidemotion'),
                    '4' => esc_html__('4', 'slidemotion'),
                    '5' => esc_html__('5', 'slidemotion'),
                ],
            ]
        );


        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'false',
            ],

        );


        $this->add_control(
            'autoplay_speed',
            [
                'label'     => esc_html__('Autoplay Speed (ms)', 'slidemotion'),
                'type'      => \Elementor\Controls_Manager::NUMBER,
                'min'       => 1000,
                'max'       => 10000,
                'step'      => 1000,
                'default'   => 3000,
                'condition' => [
                    'autoplay' => 'true',
                ],
            ]
        );

        $this->add_control(
            'infinite_scroll',
            [
                'label' => esc_html__('Infinite Scroll', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'true',
            ]
        );

        $this->add_control(
            'slider_arrows',
            [
                'label' => esc_html__('Arrows', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'true',
            ],

        );

        $this->add_control(
            'slider_dots',
            [
                'label' => esc_html__('Dots', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'false',
            ],

        );
        $this->add_control(
            'draggable',
            [
                'label' => esc_html__('Allow Dragging', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'true',
            ],

        );

        $this->add_control(
            'center_mode',
            [
                'label' => esc_html__('Partial View', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'false',
            ]
        );

        $this->add_responsive_control(
            'center_padding',
            [
                'label' => esc_html__('Partial View Padding', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 10,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => '50',
                ],
                'condition' => [
                    'center_mode' => 'true',
                ],
            ]
        );

        $this->add_control(
            'adaptive_height',
            [
                'label' => esc_html__('Auto Adjust Slide Height', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'false',
            ]
        );

        $this->add_control(
            'pause_hover',
            [
                'label' => esc_html__('Pause On Hover', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'true',
            ]
        );

        $this->add_control(
            'variable_width',
            [
                'label' => esc_html__('Variable Width', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'false',
            ]
        );

        $this->add_control(
            'vertical_scroll',
            [
                'label' => esc_html__('Vertical Sliding', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'false',
            ]
        );

        $this->add_control(
            'fade_effect',
            [
                'label' => esc_html__('Fade Effect', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'slidemotion'),
                'label_off' => esc_html__('No', 'slidemotion'),
                'return_value' => 'true',
                'default' => 'false',
            ]
        );

        $this->add_control(
            'left_arrow_icons',
            [
                'label' => esc_html__('Left Arrow Icon', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-chevron-left',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'arrow-left',
                        'chevron-left',
                        'angle-left',
                    ],
                    'fa-regular' => [
                        'arrow-left',
                        'chevron-left',
                        'angle-left',
                    ],
                ],
            ]
        );

        $this->add_control(
            'right_arrow_icons',
            [
                'label' => esc_html__('Right Arrow Icon', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-chevron-right',
                    'library' => 'fa-solid',
                ],
                'recommended' => [
                    'fa-solid' => [
                        'arrow-right',
                        'chevron-right',
                        'angle-right',
                    ],
                    'fa-regular' => [
                        'arrow-right',
                        'chevron-right',
                        'angle-right',
                    ],
                ],
            ]
        );


        $this->end_controls_section();




        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style', 'slidemotion'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        $this->add_responsive_control(
            'slide_spacing',
            [
                'label' => esc_html__('Spacing Between Slides', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slidemotion-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );



        $this->add_control(
            'icon_options',
            [
                'label' => esc_html__('Icons Options', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__('Icon Color', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .cm-list-icon' => 'color: {{VALUE}};fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_gap',
            [
                'label' => esc_html__('Icon Gap', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => '20',
                ],
                'selectors' => [
                    '{{WRAPPER}} .slidemotion-item' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon Size', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 200,
                    ],
                ],
                'default' => [
                    'size' => 40,
                    'unit' => 'px',
                ],
                'selectors' => [

                    // SVG icons (Elementor default)
                    '{{WRAPPER}} .cm-list-icon svg' =>
                    'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .cm-list-icon i' =>
                    'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_width',
            [
                'label' => __('Image Width', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .cm-list-icon' =>
                    'width: {{SIZE}}{{UNIT}}; height: auto;',
                ],
            ]
        );


        $this->add_control(
            'heading_options',
            [
                'label' => esc_html__('Heading Options', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography',
                'selector' => '{{WRAPPER}} h5.slidemotion-slide-title',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} h5.slidemotion-slide-title' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_spacing',
            [
                'label' => esc_html__('Title Spacing', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} h5.slidemotion-slide-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'title_align',
            [
                'label' => esc_html__('Title Alignment', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'slidemotion'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'slidemotion'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'slidemotion'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justify', 'slidemotion'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} h5.slidemotion-slide-title' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'content_options',
            [
                'label' => esc_html__('Content Options', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Content Color', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} div.slidemotion-slide-content' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typography_2',
                'selector' => '{{WRAPPER}} div.slidemotion-slide-content',
            ]
        );
        $this->add_responsive_control(
            'content_spacing',
            [
                'label' => esc_html__('Content Spacing', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} div.slidemotion-slide-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'content_align',
            [
                'label' => esc_html__('Content Alignment', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'slidemotion'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'slidemotion'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'slidemotion'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justify', 'slidemotion'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} div.slidemotion-slide-content' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'arrow_options',
            [
                'label' => esc_html__('Arrow Options', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->add_responsive_control(
            'arrows_size',
            [
                'label' => esc_html__('Arrows Size', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slidemotion-prev svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .slidemotion-next svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .slidemotion-prev i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .slidemotion-next i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'arrow_bg_color',
            [
                'label' => esc_html__('Arrows Background Color', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slidemotion-next.slick-arrow' => 'background-color: {{VALUE}} !important;',
                    '{{WRAPPER}} .slidemotion-prev.slick-arrow' => 'background-color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => esc_html__('Arrows Color', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slidemotion-next.slick-arrow svg' => 'fill: {{VALUE}};',
                    '{{WRAPPER}} .slidemotion-prev.slick-arrow svg' => 'fill: {{VALUE}};',
                    '{{WRAPPER}} .slidemotion-next.slick-arrow i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .slidemotion-prev.slick-arrow i' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'arrow_spacing',
            [
                'label' => esc_html__('Arrows Spacing', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .slidemotion-next.slick-arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .slidemotion-prev.slick-arrow' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_size',
            [
                'label' => esc_html__('Dots Size', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 8,
                ],
                'selectors' => [
                    '{{WRAPPER}} .cm-widget-wrapper .slick-dots li button' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'dots_spacing',
            [
                'label' => esc_html__('Dot Spacing', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'custom'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 8,
                ],
                'selectors' => [
                    '{{WRAPPER}} .cm-widget-wrapper .slick-dots li' => 'margin: 0 {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_control(
            'dot_color',
            [
                'label' => esc_html__('Dots Color', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#cccccc',
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li button' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'dot_active_color',
            [
                'label' => esc_html__('Active Dots Color', 'slidemotion'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000000',
                'selectors' => [
                    '{{WRAPPER}} .slick-dots li.slick-active button' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();
    }

    protected function render(): void
    {
        $widget_id = 'slick-widget-' . esc_attr($this->get_id());
        $settings = $this->get_settings_for_display();

        $desktop_view_partial = $settings['center_padding']['size'] ?? '';
        $tablet_view_partial  = $settings['center_padding_tablet']['size'] ?? '';
        $mobile_view_partial  = $settings['center_padding_mobile']['size'] ?? '';

        $unit = $settings['center_padding']['unit'] ?? 'px';


        // if ($settings['image_icon_items']) {
        if (!empty($settings['image_icon_items']) && is_array($settings['image_icon_items'])) {
            $type = $settings['type'] ?? 'image_icon_top';
            $align  = $settings['icon_vertical_position'] ?? 'cm-position-start';

            echo '<div class="slidemotion-slider-widget">';
            echo '<div id="' . esc_attr($widget_id) . '" class="cm-widget-wrapper cm-' . esc_attr($type) . ' ' . esc_attr($align) . '"
                data-slide-to-show="' . esc_attr($settings['slides_to_show'] ?? '1') . '"
                data-slide-to-scroll="' . esc_attr($settings['slides_to_scroll'] ?? '1') . '"
                data-autoplay="' . esc_attr($settings['autoplay'] ?? 'false') . '"
                data-infinite-scroll="' . esc_attr($settings['infinite_scroll'] ?? 'true') .  '"
                data-autoplay-speed ="' . esc_attr($settings['autoplay_speed'] ?? '3000') . '"
                data-slider-dots="' . esc_attr($settings['slider_dots'] ?? 'false') . '"
                data-draggable="' . esc_attr($settings['draggable'] ?? 'true') . '"
                data-arrows="' . esc_attr($settings['slider_arrows'] ?? 'true') . '"
                data-center-mode="' . esc_attr($settings['center_mode'] ?? 'false') . '"
                data-center-padding-desktop="' . esc_attr($desktop_view_partial . $unit) . '"
                data-center-padding-tablet="' . esc_attr($tablet_view_partial . $unit) . '"
                data-center-padding-mobile="' . esc_attr($mobile_view_partial . $unit) . '"
                data-adaptive-height="' . esc_attr($settings['adaptive_height'] ?? 'false') . '"
                data-pause-hover="' . esc_attr($settings['pause_hover'] ?? 'true') . '"
                data-variable-width="' . esc_attr($settings['variable_width'] ?? 'false') . '"
                data-vertical-scroll="' . esc_attr($settings['vertical_scroll'] ?? 'false') . '"
                data-fade-effect="' . esc_attr($settings['fade_effect'] ?? 'false') . '"

                data-slide-to-scroll-tablet="' . esc_attr($settings['tablet_slides_to_scroll'] ?? '1') . '"
                data-slide-to-show-tablet="' . esc_attr($settings['tablet_slides_to_show'] ?? '1') . '"

                data-slide-to-scroll-mobo="' . esc_attr($settings['mobo_slides_to_scroll'] ?? '1') . '"
                data-slide-to-show-mobo="' . esc_attr($settings['mobo_slides_to_show'] ?? '1') . '"
                
                >';

            foreach ($settings['image_icon_items'] as $item) {


                echo '<div class="slidemotion-item">';

                // Icon / Image
                if ($item['media_type'] === 'icon' && !empty($item['selected_icon'])) {
                    echo '<div class="cm-list-icon ' . esc_attr($align) . '">';
                    \Elementor\Icons_Manager::render_icon($item['selected_icon'], ['aria-hidden' => 'true']);
                    echo '</div>';
                }

                if ($item['media_type'] === 'image' && !empty($item['selected_image']['url'])) {
                    echo '<div class="cm-list-icon ' . esc_attr($align) . '">';
                    echo '<img src="' . esc_url($item['selected_image']['url']) . '" alt="">';
                    echo '</div>';
                }

                // Content
                echo '<div class="cm-content-wrap">';
                echo '<h5 class="slidemotion-slide-title">' . wp_kses_post($item['list_title']) . '</h5>';
                echo '<div class="slidemotion-slide-content">' . wp_kses_post($item['content_text']) . '</div>';
                echo '</div>';

                echo '</div>';
            }
            echo '</div>';

            if ($settings['slider_arrows'] === 'true') {
                if (! empty($settings['left_arrow_icons']['value'])) {
                    echo '<div class="slidemotion-prev slick-arrow">';
                    \Elementor\Icons_Manager::render_icon(
                        $settings['left_arrow_icons'],
                        ['aria-hidden' => 'true']
                    );
                    echo '</div>';
                }

                if (! empty($settings['right_arrow_icons']['value'])) {
                    echo '<div class="slidemotion-next slick-arrow">';
                    \Elementor\Icons_Manager::render_icon(
                        $settings['right_arrow_icons'],
                        ['aria-hidden' => 'true']
                    );
                    echo '</div>';
                }
            }

            echo '</div>'; // End slidemotion-slider-widget
        }
    }


    protected function content_template()
    {
?>
        <#
            var widget_id='slick-widget-' + view.getID();



            var type=settings.type ? 'cm-' + settings.type : 'cm-image_icon_top' ;
            var align=settings.icon_vertical_position ? settings.icon_vertical_position : 'cm-position-start' ;

            var desktop_padding=settings.center_padding.size ? settings.center_padding.size + settings.center_padding.unit : '50px' ;
            var tablet_padding=settings.center_padding_tablet.size ? settings.center_padding_tablet.size + settings.center_padding_tablet.unit : '20px' ;
            var mobile_padding=settings.center_padding_mobile.size ? settings.center_padding_mobile.size + settings.center_padding_mobile.unit : '10px' ;

            // Ensure we handle 'yes' from Elementor Switcher controls
            var showDots=(settings.slider_dots==='yes' || settings.slider_dots==='true' ) ? 'true' : 'false' ;
            var showArrows=(settings.slider_arrows==='yes' || settings.slider_arrows==='true' ) ? 'true' : 'false' ;
            #>

            <# if ( settings.image_icon_items.length ) { #>
                <div class="slidemotion-slider-widget">

                    <div id="{{ widget_id }}" class="cm-widget-wrapper {{ type }} {{ align }}"
                        data-slide-to-show="{{ settings.slides_to_show || '1' }}"
                        data-slide-to-scroll="{{ settings.slides_to_scroll || '1' }}"
                        data-autoplay="{{ settings.autoplay }}"
                        data-infinite-scroll="{{ settings.infinite_scroll }}"
                        data-autoplay-speed="{{ settings.autoplay_speed || '3000' }}"
                        data-slider-dots="{{ showDots }}"
                        data-arrows="{{ showArrows }}"
                        data-draggable="{{ settings.draggable }}"
                        data-center-mode="{{ settings.center_mode }}"
                        data-center-padding-desktop="{{ desktop_padding }}"
                        data-center-padding-tablet="{{ tablet_padding }}"
                        data-center-padding-mobile="{{ mobile_padding }}"
                        data-adaptive-height="{{ settings.adaptive_height }}"
                        data-pause-hover="{{ settings.pause_hover }}"
                        data-variable-width="{{ settings.variable_width }}"
                        data-vertical-scroll="{{ settings.vertical_scroll }}"
                        data-fade-effect="{{ settings.fade_effect }}"
                        data-slide-to-scroll-tablet="{{ settings.tablet_slides_to_scroll || '1' }}"
                        data-slide-to-show-tablet="{{ settings.tablet_slides_to_show || '1' }}"
                        data-slide-to-scroll-mobo="{{ settings.mobo_slides_to_scroll || '1' }}"
                        data-slide-to-show-mobo="{{ settings.mobo_slides_to_show || '1' }}">

                        <# _.each( settings.image_icon_items, function( item ) { #>
                            <div class="slidemotion-item">

                                <# if ( item.media_type==='icon' && item.selected_icon && item.selected_icon.value) { #>

                                    <div class="cm-list-icon">

                                        <# if ( item.selected_icon.library==='svg' && item.selected_icon.value.url ) { #>

                                            <img src="{{ item.selected_icon.value.url }}" alt="">

                                            <# } else {

                                                var icon=elementor.helpers.renderIcon(
                                                view,
                                                item.selected_icon,
                                                { 'aria-hidden' : true }, 'i' , 'object'
                                                );

                                                if ( icon && icon.value ) { #>

                                                {{{ icon.value }}}


                                                <# }
                                                    } #>
                                                    <# console.log(elementor.helpers.renderIcon(view, item.selected_icon)); #>

                                    </div>

                                    <# } else if ( item.media_type==='image' && item.selected_image && item.selected_image.url ) { #>
                                        <div class="cm-list-image">
                                            <img src="{{ item.selected_image.url }}" alt="">
                                        </div>
                                        <# } #>

                                            <div class="cm-content-wrap">
                                                <h5 class="slidemotion-slide-title">{{{ item.list_title }}}</h5>
                                                <div class="slidemotion-slide-content">{{{ item.content_text }}}</div>
                                            </div>
                            </div>
                            <# }); #>
                    </div>

                    <# if ( showArrows==='true' ) { #>
                        <# if ( settings.left_arrow_icons && settings.left_arrow_icons.value ) { #>
                            <div class="slidemotion-prev slick-arrow">
                                {{{ elementor.helpers.renderIcon( view, settings.left_arrow_icons, { 'aria-hidden': true }, 'i' ) }}}
                            </div>
                            <# } #>

                                <# if ( settings.right_arrow_icons && settings.right_arrow_icons.value ) { #>
                                    <div class="slidemotion-next slick-arrow">
                                        {{{ elementor.helpers.renderIcon( view, settings.right_arrow_icons, { 'aria-hidden': true }, 'i' ) }}}
                                    </div>
                                    <# } #>
                                        <# } #>

                </div>
                <# } #>
            <?php
        }
    }
