jQuery(document).ready(function ($) {
  $(".cm-widget-wrapper").each(function () {
    // const beforeEnd = 500;
    const widget_id = $(this).attr("id");
    const $widget = $("#" + widget_id).closest(".slidemotion-slider-widget");

    const imageSlider = $("#" + widget_id);
    const slidesToShow = $("#" + widget_id).data("slide-to-show");
    const slidesToScroll = $("#" + widget_id).data("slide-to-scroll");
    const autoplay = $("#" + widget_id).data("autoplay");
    const infiniteScroll = $("#" + widget_id).data("infinite-scroll");
    const centerMode = $("#" + widget_id).data("center-mode");
    const centerPadding = $("#" + widget_id).data("center-padding-desktop");
    const centerPaddingTablet = $("#" + widget_id).data(
      "center-padding-tablet",
    );
    const centerPaddingMobile = $("#" + widget_id).data(
      "center-padding-mobile",
    );
    const adaptiveHeight = $("#" + widget_id).data("adaptive-height") === true;
    const pauseOnHover = $("#" + widget_id).data("pause-hover");
    const variableWidth = $("#" + widget_id).data("variable-width");
    const verticalScroll = $("#" + widget_id).data("vertical-scroll") === true;
    const fadeEffect = $("#" + widget_id).data("fade-effect") === true;
    const arrows = $("#" + widget_id).data("arrows");
    const dots = $("#" + widget_id).data("slider-dots");
    const draggable = $("#" + widget_id).data("draggable") === true;
    const sliderTimer = $("#" + widget_id).data("autoplay-speed");
    const slideSpeed = $("#" + widget_id).data("slide-speed");

    const $prevBtn = $widget.find(".slidemotion-prev");
    const $nextBtn = $widget.find(".slidemotion-next");

    const tabletSlideToScroll = $("#" + widget_id).data(
      "slide-to-scroll-tablet",
    );
    const tabletSlidesToShow = $("#" + widget_id).data("slide-to-show-tablet");

    const moboSlideToScroll = $("#" + widget_id).data("slide-to-scroll-mobo");
    const moboSlidesToShow = $("#" + widget_id).data("slide-to-show-mobo");

    imageSlider.slick({
      dots: dots,
      arrows: arrows,
      draggable: draggable,
      prevArrow: $prevBtn,
      nextArrow: $nextBtn,
      infinite: infiniteScroll,
      autoplay: autoplay,
      autoplaySpeed: sliderTimer,
      slidesToShow: slidesToShow,
      slidesToScroll: slidesToScroll,
      centerMode: centerMode,
      centerPadding: centerPadding,
      adaptiveHeight: adaptiveHeight,
      pauseOnHover: pauseOnHover,
      pauseOnFocus: pauseOnHover,
      variableWidth: variableWidth,
      vertical: verticalScroll,
      fade: fadeEffect,
      cssEase: "linear",

      responsive: [
        {
          breakpoint: 769,
          settings: {
            slidesToShow: tabletSlidesToShow,
            slidesToScroll: tabletSlideToScroll,
            centerPadding:  centerPaddingTablet,
          },
        },
        {
          breakpoint: 480,
          settings: {
            slidesToShow: moboSlidesToShow,
            slidesToScroll: moboSlideToScroll,
            centerPadding: centerPaddingMobile,
          },
        },
        // You can unslick at a given breakpoint now by adding:
        // settings: "unslick"
        // instead of a settings object
      ],
    });
    console.log(imageSlider.slick("getSlick").options);
  });
});
