(function ($) {
  function initOrUpdateSlick($scope) {
    const $slider = $scope.find(".cm-widget-wrapper");
    if (!$slider.length) return;

    const getBool = (val) => val === "true" || val === true || val === "yes";

    const slickOptions = {
      slidesToShow: parseInt($slider.data("slide-to-show")) || 1,
      slidesToScroll: parseInt($slider.data("slide-to-scroll")) || 1,
      dots: getBool($slider.data("slider-dots")),
      arrows: getBool($slider.data("arrows")),
      autoplay: getBool($slider.data("autoplay")),
      autoplaySpeed: parseInt($slider.data("autoplay-speed")) || 3000,
      infinite: getBool($slider.data("infinite-scroll")),
      centerMode: getBool($slider.data("center-mode")),
      centerPadding: $slider.data("center-padding-desktop") || "50px",
      adaptiveHeight: getBool($slider.data("adaptive-height")),
      variableWidth: getBool($slider.data("variable-width")),
      vertical: getBool($slider.data("vertical-scroll")),
      fade: getBool($slider.data("fade-effect")),
      pauseOnHover: getBool($slider.data("pause-hover")),
      prevArrow: $scope.find(".slidemotion-prev"),
      nextArrow: $scope.find(".slidemotion-next"),
      responsive: [
        {
          breakpoint: 1025,
          settings: {
            slidesToShow: parseInt($slider.data("slide-to-show-tablet")) || 1,
            slidesToScroll:
              parseInt($slider.data("slide-to-scroll-tablet")) || 1,
            centerPadding: $slider.data("center-padding-tablet") || "30px",
          },
        },
        {
          breakpoint: 768,
          settings: {
            slidesToShow: parseInt($slider.data("slide-to-show-mobo")) || 1,
            slidesToScroll: parseInt($slider.data("slide-to-scroll-mobo")) || 1,
            centerPadding: $slider.data("center-padding-mobile") || "20px",
          },
        },
      ],
    };

    // REAL INSTANCE CHECK
    const slickInstance = $slider.get(0).slick;

    // FIRST LOAD OR EDITOR RE-RENDER
    if (!slickInstance) {
      $slider.slick(slickOptions);
      return;
    }

    // STRUCTURAL CHANGES NEED REBUILD
    const needsRebuild =
      slickInstance.options.vertical !== slickOptions.vertical ||
      slickInstance.options.fade !== slickOptions.fade ||
      slickInstance.options.variableWidth !== slickOptions.variableWidth ||
      slickInstance.options.centerMode !== slickOptions.centerMode;

    if (needsRebuild) {
      $slider.slick("unslick").slick(slickOptions);
      return;
    }

    // SAFE LIVE UPDATE
    $slider.slick("slickSetOption", slickOptions, true);
  }

  $(window).on("elementor/frontend/init", function () {
    elementorFrontend.hooks.addAction(
      "frontend/element_ready/slidemotion.default",
      initOrUpdateSlick,
    );
  });
})(jQuery);
