<?php
/*
Plugin Name: SkynetAccessibility Scanner
Plugin URI: https://www.skynettechnologies.com/accessibility-scanning-and-monitoring
Description: Adds a SkynetAccessiblity Scanner inside the WordPress admin dashboard for automated accessibility scanning and WCAG compliance tracking.
Version: 1.0
Author: Skynet Technologies USA LLC
Author URI: https://www.skynettechnologies.com
License: GPL2
License URI: https://www.gnu.org/licenses/gpl-2.0.html
Text Domain: skynetaccessibility-scanner
*/

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Register Admin Menu
 */
function sas_register_admin_menu() {
    add_menu_page(
        'SkynetAccessiblity Scanner',   // Page title
        'SkynetAccessiblity Scanner',     // Menu title
        'manage_options',                        // Capability
        'skynet-accessibility-scanner',     // Menu slug
        'sas_admin_page_content',                // Callback function
        'dashicons-universal-access-alt',        // Icon
        20                                       // Position
    );
}
add_action('admin_menu', 'sas_register_admin_menu');

/**
 * Enqueue CSS & JS
 */
function sas_enqueue_assets($hook) {
    if ($hook != 'toplevel_page_skynet-accessibility-scanner') {
        return;
    }

    $plugin_url = plugin_dir_url( __FILE__ );
    $plugin_dir = plugin_dir_path( __FILE__ );

    wp_enqueue_style(
        'sas-style',
        esc_url( $plugin_url . 'skynetaccessibility-scanner.css' ),
        array(),
        '1.0'
    );

    $js_dir = $plugin_dir . 'JS/';
    if ( is_dir( $js_dir ) ) {
        foreach ( glob( $js_dir . '*.js' ) as $js_file ) {
            $handle = 'sas-' . basename( $js_file, '.js' );
            wp_enqueue_script(
                $handle,
                esc_url( $plugin_url . 'JS/' . basename( $js_file ) ),
                array( 'jquery' ),
                '1.0',
                true
            );
        }
    }
}
add_action('admin_enqueue_scripts', 'sas_enqueue_assets');

/**
 * Admin Page Content
 */
function sas_admin_page_content() {
	
// Get domain from WordPress
$site_url = get_site_url();
$parsed_url = wp_parse_url($site_url);
$websitename = $parsed_url['host'];



// Prepare details
$arrDetails = [
    'website'        => base64_encode($websitename), // Encode domain
    'platform'       => 'wordpress',
    'is_trial_period'=> 1,
    'name'           => $websitename,
    'email'          => 'no-reply@' . $websitename,
    'comapany_name'  => $websitename,
    'package_type'   => '25-pages'
];

// Use wp_remote_post instead of curl
$response = wp_remote_post(
    'https://skynetaccessibilityscan.com/api/register-domain-platform',
    [
        'body'    => $arrDetails,
        'timeout' => 20,
    ]
);

// Handle response
if (is_wp_error($response)) {
    echo esc_html('Request error: ' . $response->get_error_message());
} else {
    $body = wp_remote_retrieve_body($response);

    // Decode API response
    $jsonStart = strpos($body, '{');
    if ($jsonStart !== false) {
        $jsonPart = substr($body, $jsonStart);
        $result = json_decode($jsonPart, true);

        // Do something with $result
        // print_r($result);
    } else {
        echo  esc_html("Invalid response: " . $body);
    }
}

//Get Scan result

// Get domain safely from WordPress
$site_url = get_site_url();
$parsed_url = wp_parse_url($site_url);
$domain_name = $parsed_url['host'];


// Prepare request body
$body = [
    'website' => base64_encode($domain_name),
];

// Make request with WordPress HTTP API
$response = wp_remote_post(
    'https://skynetaccessibilityscan.com/api/get-scan-detail',
    [
        'body'    => $body,
        'timeout' => 20,
    ]
);

// Handle response
if (is_wp_error($response)) {
    echo  esc_html('Request error: ' . $response->get_error_message());
} else {
    $body = wp_remote_retrieve_body($response);
    
    // If response is JSON, decode it
    $result = json_decode($body, true);
	
	
	if ($result) {
         // Fetch scan detail response data
        if (isset($result['data'][0])) {
            $row = $result['data'][0];

            $domain              = $row['domain'] ?? '';
			$fav_icon            = $row['fav_icon'] ?? '';
			$url_scan_status     = $row['url_scan_status'] ?? 0;
			$scan_status         = $row['scan_status'] ?? 0;
			$total_selected_pages= $row['total_selected_pages'] ?? 0;
			$total_last_scan_pages= $row['total_last_scan_pages'] ?? 0;
			$total_pages         = $row['total_pages'] ?? 0;
			$last_url_scan       = $row['last_url_scan'] ?? 0;
			$total_scan_pages    = $row['total_scan_pages'] ?? 0;
			$last_scan           = $row['last_scan'] ?? null;
			$next_scan_date      = $row['next_scan_date'] ?? null;
			$success_percentage  = $row['success_percentage'] ?? '0';
			$scan_violation_total= $row['scan_violation_total'] ?? '0';
			$total_violations    = $row['total_violations'] ?? 0;
			$package_name        = $row['name'] ?? '';
			$package_id          = $row['package_id'] ?? '';
			$page_views          = $row['page_views'] ?? '';
			$package_price       = $row['package_price'] ?? '';
			$subscr_interval     = $row['subscr_interval'] ?? '';
			$end_date            = $row['end_date'] ?? '';
			$website_id          = $row['website_id'] ?? '';
			$dashboard_link      = $result['dashboard_link'] ?? '';
			$total_fail_sum      = $row['total_fail_sum'] ?? '';
			$payment_status      = $row['payment_status'] ?? '';
			$is_expired      = $row['is_expired'] ?? '';
			$is_trial_period = $row['is_trial_period'] ?? '';
			
			
			$data['domain'] = $row['domain'] ?? '';
            $data['fav_icon'] = $row['fav_icon'] ?? '';
            $data['url_scan_status'] = $row['url_scan_status'] ?? 0;
            $data['scan_status']= $row['scan_status'] ?? 0;
            $data['total_selected_pages'] = $row['total_selected_pages'];
            $data['total_last_scan_pages'] = $row['total_last_scan_pages'];
            $data['total_pages'] = $row['total_pages'] ?? 0;
            $data['last_url_scan'] = $row['last_url_scan'] ?? 0;
            $data['total_scan_pages'] = $row['total_scan_pages'] ?? 0;
            $data['last_scan'] = $row['last_scan'] ?? null;
            $data['next_scan_date'] = $row['next_scan_date'] ?? null;
            $data['success_percentage'] = $row['success_percentage'] ?? '0';
            $data['scan_violation_total'] = $row['scan_violation_total'] ?? '0';
            $data['total_violations'] = $row['total_violations'] ?? 0;
            $data['package_name'] = $row['name'] ?? '';
            $data['package_id'] = $row['package_id'] ?? '';
            $data['page_views'] = $row['page_views'] ?? '';
            $data['package_price'] = $row['package_price'] ?? '';
            $data['subscr_interval'] = $row['subscr_interval'] ?? '';
            $data['end_date'] = $row['end_date'] ?? '';
            $data['website_id'] = $row['website_id'] ?? '';
            $data['dashboard_link'] = $result['dashboard_link'] ?? '';
            $data['total_fail_sum'] = $row['total_fail_sum'] ?? '';
			$data['payment_status'] = $row['payment_status'] ?? '';
			$data['is_expired'] = $row['is_expired'] ?? '';
			$data['is_trial_period'] = $row['is_trial_period'] ?? '';
			
			
			

        }
        // end Get scan detail API 
		
		 
    } else {
        echo  esc_html("Invalid response: " . $body);
    }
}


// Get Scan Count API (Fetch the violation report data)


$response1 = wp_remote_post(
    'https://skynetaccessibilityscan.com/api/get-scan-count',
    [
        'body'    => [
            'website' => base64_encode($domain_name), // same as in first API
        ],
        'timeout' => 20,
    ]
);

// Handle errors
if (is_wp_error($response1)) {
    $error_message = $response1->get_error_message();
    $result1 = [];
} else {
    $body1   = wp_remote_retrieve_body($response1);
    $result1 = json_decode($body1, true);
}


// Safely fetch values
$with_rem    = $result1['scan_details']['with_remediation'] ?? [];
$without_rem = $result1['scan_details']['without_remediation'] ?? [];

$widget_purchased =$result1['widget_purchased'];

$scan_details = [
    'with_remediation'    => $with_rem,
    'without_remediation' => $without_rem,
];

// Fetch package list payload
$payload = wp_json_encode([
    'website' => base64_encode($domain_name),
]);

///

            // Fetch package list
            $response2 = wp_remote_post(
                'https://skynetaccessibilityscan.com/api/packages-list',
                [
                    'body'        => $payload,
                    'timeout'     => 30,
                    'sslverify'   => false,
                    'headers'     => [
                        'Content-Type' => 'application/json',
                    ],
                ]
            );
            
            $decoded = [];
            if (!is_wp_error($response2)) {
                $decoded = json_decode(wp_remote_retrieve_body($response2), true);
            }
			
			
			
            // Active package info
            $activePackageId = $data['package_id'] ?? '';
            $activeInterval  = $data['subscr_interval'] ?? ''; // 'M' or 'Y'
            $allowedNames    = ['Small Site', 'Medium Site', 'Large Site', 'Extra Large Site'];
			
            $plans           = [];
            
           $websiteId = (string)($data['website_id'] ?? ''); 
		   
		   $today = new \DateTime('now', new \DateTimeZone('UTC'));

		   $todayStr = $today->format('Y-m-d');
		   
		  
           
            // Find current active package
            if (!empty($decoded['current_active_package'])) {
                foreach ($decoded['current_active_package'] as $key => $package) {
                    if ((string)$key === $websiteId) {
						
						
						
						$endDate = !empty($package['end_date']) ? new \DateTime($package['end_date'], new \DateTimeZone('UTC')) : null;
						
                        if ($endDate && $endDate->format('Y-m-d') === $todayStr) {

							if (!empty($decoded['expired_package_detail'][$websiteId])) {
			
								$expiredPackage = $decoded['expired_package_detail'][$websiteId];
			
								$data['expired_package'] = $expiredPackage;
			
			
			
								$activePackageId = $expiredPackage['package_id'] ?? '';
			
								$activeInterval  = $expiredPackage['subscr_interval'] ?? '';
			
							}
			
						} else {
			
							$activePackageId = $package['package_id'] ?? '';
			
							$activeInterval  = $package['subscr_interval'] ?? '';
			
						}
                        break;
                    }
                }
            }elseif (!empty($decoded['expired_package_detail'])) {

				if (!empty($decoded['expired_package_detail'][$websiteId])) {
			
					$expiredPackage = $decoded['expired_package_detail'][$websiteId];
			
					$data['expired_package'] = $expiredPackage;
			
			
			
					$activePackageId = $expiredPackage['package_id'] ?? '';
			
					$activeInterval  = $expiredPackage['subscr_interval'] ?? '';
			
				}
			
			}
			
            
            
            // Get final price
            if (!empty($decoded['current_active_package'])) {

				$data1 = $decoded['current_active_package'];
			
				$firstKey = array_key_first($data1);
				
				
			
				if ($firstKey !== null) {
			
					$finalPrice = $data1[$firstKey]['final_price'] ?? 0;
			
					$data['final_price'] = $finalPrice;
			
				}
			
			} elseif (!empty($decoded['expired_package_detail'])) {
			
				$firstKey = array_key_first($decoded['expired_package_detail']);
			
				$finalPrice = $decoded['expired_package_detail'][$firstKey]['final_price'] ?? 0;
			
				$data['final_price'] = $finalPrice;
			
			}
			
            
			
            $data['final_price'] = $finalPrice;
            $final_price = $finalPrice;
			
			
            // Loop through available plans
            if (!empty($decoded['Data'])) {
                foreach ($decoded['Data'] as $plan) {
                    if (isset($plan['name']) && in_array($plan['name'], $allowedNames)) {
                        $packageId = $plan['id'] ?? null;
                        if (!$packageId) {
                            continue; // skip if no ID
                        }
            
                        $action = 'upgrade'; // default action



        			// Check if current active package matches this plan

					if ($packageId == $activePackageId) {
			
						$plan['interval'] = $activeInterval; // 'M' or 'Y'
			
			
			
						// Check if subscription has expired
			
						$endDateStr = $data['end_date'] ?? ''; // end date from backend
			
						if ($endDateStr) {
			
							$endDate = new \DateTime($endDateStr, new \DateTimeZone('UTC'));
			
							if ($today <= $endDate) {
			
								// Still active → allow cancel
			
								$action = 'cancel';
			
							} else {
			
								// Expired → force upgrade
			
								$action = 'upgrade';
			
							}
			
						} else {
			
							// If no end_date, default to cancel for active package
			
							$action = 'cancel';
			
						}
			
					}
					
					$plan['action'] = $action; // attach action to plan



					$data['activePackageId'] = $activePackageId;
			
					$data['packageId']       = $packageId;
			
					$data['websiteId']       = $websiteId;
					
					$payment_status = $data['payment_status'];
					
					$is_trial_period_active='';
					
					
					
					// Generate autologin link (upgrade/cancel)
                        $link_response = wp_remote_post(
                            'https://skynetaccessibilityscan.com/api/generate-plan-action-link',
                            [
                                'body'      => [
                                    'package_id'         => $packageId,
                                    'current_package_id' => $activePackageId,
                                    'interval'           => 'M',
                                    'website_id'         => $websiteId,
                                    'action'             => $action,
                                ],
                                'timeout'   => 20,
                                'sslverify' => false,
                            ]
                        );
            
                        $decodedLink = !is_wp_error($link_response)
                            ? json_decode(wp_remote_retrieve_body($link_response), true)
                            : [];
            
                        $plan['dashboard_link'] = $decodedLink['action_link'] ?? '#';
                        $plan['action']         = $action;
						$plan['is_trial_period_active']         = $is_trial_period_active;
						
						$yearly_link_response = wp_remote_post(
                            'https://skynetaccessibilityscan.com/api/generate-plan-action-link',
                            [
                                'body'      => [
                                    'package_id'         => $packageId,
                                    'current_package_id' => $activePackageId,
                                    'interval'           => 'Y',
                                    'website_id'         => $websiteId,
                                    'action'             => 'upgrade',
                                ],
                                'timeout'   => 20,
                                'sslverify' => false,
                            ]
                        );
            
                        $decodedLink_year = !is_wp_error($yearly_link_response)
                            ? json_decode(wp_remote_retrieve_body($yearly_link_response), true)
                            : [];
            
							;
						
                        $plan['dashboard_link_yearly'] = $decodedLink_year['action_link'] ? $decodedLink_year['action_link'] : '#';
                       
						//EOF
					
					$plans[] = $plan;
					
				
                        // Generate violation autologin link
                        $violation_response = wp_remote_post(
                            'https://skynetaccessibilityscan.com/api/generate-plan-action-link',
                            [
                                'body'      => [
                                    'website_id'         => $websiteId,
                                    'current_package_id' => $activePackageId,
                                    'action'             => 'violation',
                                ],
                                'timeout'   => 20,
                                'sslverify' => false,
                            ]
                        );
            
                        $decodedLink1 = !is_wp_error($violation_response)
                            ? json_decode(wp_remote_retrieve_body($violation_response), true)
                            : [];
                            
                        $plan['dashboard_link'] = $decodedLink1['action_link'] ?? '#';
            
                        $data['violation_link'] = $decodedLink1['action_link'] ? $decodedLink1['action_link'] : '#';
                        
                        $violationLink = $data['violation_link'];
						
						//cancel link
						
						 // Generate violation autologin link
                        $cancel_reponse = wp_remote_post(
                            'https://skynetaccessibilityscan.com/api/generate-plan-action-link',
                            [
                                'body'      => [
                                    'website_id'         => $websiteId,
                                    'current_package_id' => $activePackageId,
                                    'action'             => 'cancel',
                                ],
                                'timeout'   => 20,
                                'sslverify' => false,
                            ]
                        );
            
                        $cancel_link = !is_wp_error($cancel_reponse)
                            ? json_decode(wp_remote_retrieve_body($cancel_reponse), true)
                            : [];
                            
                       $cancel_link = $cancel_link['action_link'] ? $cancel_link['action_link'] : '#';
					   
					   
						
                    }
                }
            }
			
			
			
			?>
    


    <div class="wrap">
        <h1>SkynetAccessiblity Scanner</h1>
        <div class="sam-app">
            <div class="scanning-monitoring-app">
            
        <div id="section1">

            <div class="scans">
                <p class="title">My Scans</p>
    
                 <!-- Status Section -->
                <section class="status">
                    <div class="page-background"></div>
            
                    <!-- Scan Score -->
                    <div class="status-card">
                        <span class="status-title">Scan Score</span>
                        <?php
                        // Default values (Twig's "|default()")
                        $is_expired            = isset($is_expired) ? intval($is_expired) : 0;
                        $scan_violation_total  = isset($scan_violation_total) ? intval($scan_violation_total) : 0;
                        $success_percentage    = isset($success_percentage) ? floatval($success_percentage) : 0;
                        $total_fail_sum        = isset($total_fail_sum) ? intval($total_fail_sum) : 0;
                        ?>
                    
                        <?php if ($is_expired === 1 || $payment_status=='Canceled' ): ?>
                            	 <button class="status-progress" aria-controls="section2" onclick="plan_is_expire()">
                                        <span class="percentage text-green <?php echo esc_attr($success_percentage); ?>"><?php echo esc_html($success_percentage); ?>%</span>
                                        <div class="progress-bar">
                                        <div class="progress-fill {{ progress_color }}" style="width: <?php echo esc_attr($success_percentage); ?>%;"></div>
                                        </div>
                                        <div class="violations">
                                        Violations:
                                        <span class="violations-count"><?php echo esc_html($total_fail_sum); ?></span>
                                        </div>
                                    </button>
                        <?php else: ?>
                            <?php if ($scan_violation_total === 0): ?>
                                <span class="status-value status-inactive">N/A</span>
                            <?php else: ?>
                                    <button class="status-progress" aria-controls="section2" onclick="showDetails()">
                                        <span class="percentage text-green <?php echo esc_attr($success_percentage); ?>"><?php echo esc_html($success_percentage); ?>%</span>
                                        <div class="progress-bar">
                                        <div class="progress-fill {{ progress_color }}" style="width: <?php echo esc_attr($success_percentage); ?>%;"></div>
                                        </div>
                                        <div class="violations">
                                        Violations:
                                        <span class="violations-count"><?php echo esc_html($total_fail_sum); ?></span>
                                        </div>
                                    </button>
                                    
                                    
                                
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>

            
                   <div class="status-card">
                    <span class="status-title"><?php esc_html_e('Last Scanned', 'skynetaccessibility-scanner'); ?></span>
                    
                     <?php if ($scan_status === 1 || $scan_status === 2): ?>
                    	<div class="loader"></div>
                      <?php endif;?>
                	
                    <?php 
                    // Set default values to avoid undefined variable warnings
                    $url_scan_status = isset($url_scan_status) ? intval($url_scan_status) : 0;
                    $scan_status = isset($scan_status) ? intval($scan_status) : 0;
                    $total_scan_pages = isset($total_scan_pages) ? intval($total_scan_pages) : 0;
                    $total_selected_pages = isset($total_selected_pages) ? intval($total_selected_pages) : 0;
                    $last_scan = isset($last_scan) ? $last_scan : '';
                    
                    // Theme-safe path for placeholder image
                    $image_not_shared = esc_url(plugin_dir_url(__FILE__) . 'Image/not-shared.svg');
                    ?>
                
                    <?php if ($url_scan_status < 2): ?>
                        <span class="status-value status-inactive">
                            <img src="<?php echo  esc_url($image_not_shared); ?>" alt="<?php esc_attr_e('Not Started', 'skynetaccessibility-scanner'); ?>" title="<?php esc_attr_e('Not Started', 'skynetaccessibility-scanner'); ?>">
                            <?php esc_html_e('Not Started', 'skynetaccessibility-scanner'); ?>
                        </span>
                
                    <?php elseif ($scan_status === 0): ?>
                        <span class="status-value status-inactive">
                            <img src="<?php echo esc_url($image_not_shared); ?>" alt="<?php esc_attr_e('Not Started', 'skynetaccessibility-scanner'); ?>" title="<?php esc_attr_e('Not Started', 'skynetaccessibility-scanner'); ?>">
                            <?php esc_html_e('Not Started', 'skynetaccessibility-scanner'); ?>
                        </span>
                
                    <?php elseif ($scan_status === 1 || $scan_status === 2): ?>
                    	
                        <span class="status-value status-inactive">
                            <img src="<?php echo esc_url($image_not_shared); ?>" alt="<?php esc_attr_e('Scanning in process', 'skynetaccessibility-scanner'); ?>" title="<?php esc_attr_e('Scanning in process', 'skynetaccessibility-scanner'); ?>">
                            <?php esc_html_e('Scanning', 'skynetaccessibility-scanner'); ?><br>
                            <center><?php echo esc_html($total_scan_pages) . '/' . esc_html($total_selected_pages); ?></center>
                        </span>
                
                    <?php elseif ($scan_status === 3): ?>
                        <span class="status-value">
							<div class="scan-pages">
                            <?php echo esc_html($total_scan_pages); ?> <?php esc_html_e('Pages', 'skynetaccessibility-scanner'); ?></div>
                            <?php 
                            if (!empty($last_scan)) {
                                echo esc_html( date_i18n('F j, Y', strtotime($last_scan)) );
                            }
                            ?> <br>
                            <span class="next-scan">Next Scan on: 
                            <?php 
                            if (!empty($last_scan)) {
                                echo esc_html( date_i18n('F j, Y', strtotime($next_scan_date)) );
                            }
                            ?>
							</span>
                        </span>
                    <?php endif; ?>
                </div>

            
                </section>
                
               
    
                <hr class="divider">
    
                <section class="plan">
                    <div class="page-background"></div>
                    <div class="plan-info">
                        <div class="plans-left">
                            <span class="plan-type free">
                                <div class="icon-circle">
                                    <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'Image/round.svg');?>" 
                                         alt="<?php esc_attr_e('Plan Icon', 'skynetaccessibility-scanner'); ?>" 
                                         height="20" width="20">
                                </div>
                
                                <?php
                                // Default values to avoid undefined variable warnings
                                $end_date = isset($end_date) ? $end_date : '';
                                $is_trial_period = isset($is_trial_period) ? intval($is_trial_period) : 0;
                                $package_name = isset($package_name) ? $package_name : esc_html__('Free', 'skynetaccessibility-scanner');
                                $page_views = isset($page_views) ? intval($page_views) : 0;
                                $dashboard_link = isset($dashboard_link) ? esc_url($dashboard_link) : '#';
                
                                $now = current_time('Y-m-d');
                                $end_date_formatted = !empty($end_date) ? date_i18n('Y-m-d', strtotime($end_date)) : '';
								
								if($payment_status=='Canceled'){
									
									echo '<span style="color: #9F0000; font-weight: 700;">' . esc_html__('Subscription Cancelled', 'skynetaccessibility-scanner') . '</span>';
									
								}else if (!empty($end_date) && $end_date_formatted < $now) {
                                    echo '<span style="color: #9F0000; font-weight: 700;">' . esc_html__('Subscription Expired', 'skynetaccessibility-scanner') . '</span>';
                                } else {
									if ($is_trial_period === 1) {
                                        echo esc_html__('10 Days Trial Plan', 'skynetaccessibility-scanner');
                                    } else {
                                        echo esc_html($package_name) . ' ' . esc_html__('Plan', 'skynetaccessibility-scanner');
                                    }
                                }
                                ?>
                            </span>
                            
                            <?php if($payment_status!='Canceled'){?>
                
                                <span class="plan-desc">
                                    <ul>
                                        <?php if (empty($end_date) || $end_date_formatted >= $now): ?>
                                            <li><?php 
																  /* translators: %d: Number of pages included in the scan limit */
																  
																  echo sprintf(esc_html__('Scan up to %d Pages', 'skynetaccessibility-scanner'), esc_html($page_views)); ?></li>
                                        <?php endif; ?>
                                    </ul>
                                </span>
                                <?php if (!empty($end_date) && $end_date_formatted > $now) {?>
                                    <span class="plan-badge"><?php esc_html_e('Current Plan', 'skynetaccessibility-scanner'); ?></span>
                                <?php }?>
                            
                            <?php }?>
                        </div>
                
                        <div class="plans-right">
                            <span class="plan-renewal">
                            	<?php if($payment_status=='Canceled'){?>
                                	<?php esc_html_e('Cancelled on:', 'skynetaccessibility-scanner'); ?>
								<?php }elseif($is_expired == 1) {?>
                                	<?php esc_html_e('Expired on:', 'skynetaccessibility-scanner'); ?>
                            	<?php }elseif($is_trial_period == 1) {?>
                                 	<?php esc_html_e('Expires on:', 'skynetaccessibility-scanner'); ?>
	                          <?php }else{?>
	                                <?php esc_html_e('Renews on:', 'skynetaccessibility-scanner'); ?>
                                 <?php }?>
                                <strong>
                                    <?php
                                    if (!empty($end_date)) {
                                        echo esc_html(date_i18n('F j, Y', strtotime($end_date)));
                                    }
                                    ?>
                                </strong>
                            </span>
                            <?php if($is_expired == 1) {?>
                            	 <button 
                                class="cancel-btn" 
                                style="<?php if (!empty($end_date) && $end_date_formatted < $now) echo 'background-color: #9f0000; color: #fff;'; ?>" 
                                onclick="window.open('<?php echo esc_url($dashboard_link); ?>', '_blank')">
                                <?php 
                                if (!empty($end_date) && $end_date_formatted < $now) {
                                    esc_html_e('Renew Plan', 'skynetaccessibility-scanner');
                                } else {
                                    esc_html_e('Cancel Subscription', 'skynetaccessibility-scanner');
                                }
                                ?>
                            </button>
                            
                			<?php }elseif ($is_trial_period == 1)   {?>
                            <button 
                                class="cancel-btn" 
                                style="<?php if (!empty($end_date) && $end_date_formatted < $now) echo 'background-color: #9f0000; color: #fff;'; ?>" 
                                onclick="window.open('<?php echo esc_url($cancel_link); ?>', '_blank')">
                                <?php esc_html_e('Cancel Trial', 'skynetaccessibility-scanner');?>
                            </button>
                            <?php }?>
                            
                        </div>
                    </div>
                </section>

   
                <!-- Plan Section -->
                    <section class="pricing">
                        <div class="page-background"></div>
                    
                        <!-- Billing Toggle -->
                        <div class="billing-toggle">
                            <span class="label active" id="monthly-label">Pay Monthly</span>
                            
							<?php
							$billing_interval = $billing_interval ?? 'M'; // default to Monthly if not set

							$aria_pressed = ($billing_interval === 'Y') ? 'true' : 'false';
							$aria_label   = ($billing_interval === 'Y') ? 'Switch to Monthly Billing' : 'Switch to Annual Billing';
							?>
                            
                             <button
                                type="button"
                                id="billing-toggle"
                                class="switch"
                                role="switch"
                               aria-pressed="<?php echo esc_attr($aria_pressed); ?>"
    							aria-label="<?php echo esc_attr($aria_label); ?>"
                              >
                                <span class="slider"></span>
                              </button>
                      </button>
                            
                            <span class="label" id="annual-label">Pay Annually</span>
                            <span class="save" id="save20">Save 20%</span>
                        </div>
                    
                        <!-- Monthly Plans -->
                        
                        <div id="monthlyclass" class="monthlyclass">
                            <div class="pricing-tiers">
                                <?php if (!empty($plans)): ?>
                                    <?php foreach ($plans as $plan): ?>
                                    
                                         <?php
                                            // Choose image based on plan name
                                            $icon_file = 'diamond.svg'; // default
                                            
                                            switch ( strtolower( $plan['name'] ) ) {
                                                case 'medium site':
                                                    $icon_file = 'pentagon.svg';
                                                    break;
                                                case 'large site':
                                                    $icon_file = 'hexagon.svg';
                                                    break;
                                                case 'extra large site':
                                                    $icon_file = 'octagon.svg';
                                                    break;
                                                case 'small site':
                                                default:
                                                    $icon_file = 'diamond.svg';
                                                    break;
                                            }
                                            ?>
                                    
                                        <div class="tier"
                                            data-plan-id="<?php echo esc_attr($plan['id']); ?>"
                                            data-annual-price="<?php echo esc_attr($plan['price']); ?>"
                                            data-monthly-price="<?php echo esc_attr($plan['monthly_price']); ?>">
									
										<div class="pricing-top-tier">
                                            <div class="pricing-top">
                                                <div class="pricing-header">
                                                    <div class="icon-circle">
                                                        <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'Image/'. $icon_file); ?>" alt="" height="20" width="20">
                                                    </div>
                                                </div>
                                                <div class="pricing-info">
                                                    <h3 class="tier-title"><?php echo esc_html($plan['name']); ?></h3>
                                                    <p class="tier-pages"><?php echo intval($plan['page_views']); ?> Pages</p>
                                                    
                                                </div>
                                            </div>
											<?php if($plan['is_trial_period_active']=='1'){?>
	                                                    <p class="tier-trial"><?php echo ($plan['is_trial_period_active']=='1') ? 'Trial' : ''; ?></p>
                                                    <?php }?>
										</div>
                                            <hr class="pricing-divider">
                    
                                            <div class="pricing-body" aria-label="Original price: $<?php echo esc_html($plan['strick_monthly_price']); ?> per month. Now: $<?php echo esc_html($plan['monthly_price']); ?> per month.">
                                                <p class="old-price" aria-hidden="true">$<?php echo esc_html($plan['strick_monthly_price']); ?></p>
                                                <p class="new-price" aria-hidden="true">$<?php echo esc_html($plan['monthly_price']); ?><span class="per-year">/Monthly</span></p>
                                            </div>
                    
                                            <button 
                                                class="upgrade-btn <?php echo ($plan['action'] === 'cancel' && $final_price == $plan['monthly_price']) ? 'cancel-btnn' : ''; ?>"
                                                onclick="window.open('<?php echo esc_url($plan['dashboard_link']); ?>', '_blank')">
                                                <?php echo ($plan['action'] === 'cancel' && $final_price == $plan['monthly_price']) ? 'Cancel' : 'Upgrade'; ?>
                                            </button>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p>No plans available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        
                    
                        <!-- Annual Plans -->
                        <div id="annualclass" class="annualclass">
                            <div class="pricing-tiers">
                                <?php if (!empty($plans)): ?>
                                    <?php foreach ($plans as $plan): ?>
                                        <?php
                                            // Choose image based on plan name
                                            $icon_file = 'diamond.svg'; // default
                                            
                                            switch ( strtolower( $plan['name'] ) ) {
                                                case 'medium site':
                                                    $icon_file = 'pentagon.svg';
                                                    break;
                                                case 'large site':
                                                    $icon_file = 'hexagon.svg';
                                                    break;
                                                case 'extra large site':
                                                    $icon_file = 'hexagon.svg';
                                                    break;
                                                case 'small site':
                                                default:
                                                    $icon_file = 'diamond.svg';
                                                    break;
                                            }
                                            ?>
                                        <div class="tier"
                                            data-plan-id="<?php echo esc_attr($plan['id']); ?>"
                                            data-annual-price="<?php echo esc_attr($plan['strick_price']); ?>"
                                            data-monthly-price="<?php echo esc_attr($plan['strick_monthly_price']); ?>">
                    
										<div class="pricing-top-tier">
                                            <div class="pricing-top">
                                                <div class="pricing-header">
                                                    <div class="icon-circle">
                                                         <img src="<?php echo esc_url(plugin_dir_url(__FILE__) . 'Image/'. $icon_file); ?>" alt="" height="20" width="20">
                                                    </div>
                                                </div>
                                                <div class="pricing-info">
                                                    <h3 class="tier-title"><?php echo esc_html($plan['name']); ?></h3>
                                                    <p class="tier-pages"><?php echo intval($plan['page_views']); ?> Pages</p>
                                                </div>
                                            </div>
										</div>
                    
                                            <hr class="pricing-divider">
                    
                                            <div class="pricing-body" aria-label="Original price: $<?php echo esc_html($plan['strick_price']); ?> per year. Now: $<?php echo esc_html($plan['price']); ?> per year.">
                                                <p class="old-price" aria-hidden="true">$<?php echo esc_html($plan['strick_price']); ?></p>
                                                <p class="new-price" aria-hidden="true">$<?php echo esc_html($plan['price']); ?><span class="per-year">/Year</span></p>
                                            </div>
                    
                                            <button 
                                                class="upgrade-btn <?php echo ($plan['action'] === 'cancel' && $final_price == $plan['price']) ? 'cancel-btnn' : ''; ?>"
                                                onclick="window.open('<?php echo esc_url($plan['dashboard_link_yearly']); ?>', '_blank')">
                                                <?php echo ($plan['action'] === 'cancel' && $final_price == $plan['price']) ? 'Cancel' : 'Upgrade'; ?>
                                            </button>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                    <p>No plans available.</p>
                                <?php endif; ?>
                            </div>
                        </div>
    
                    <p class="pricing-contact">
                        Are you looking for a custom plan or Enterprise
                        plan? Contact us
                        <a href="mailto:hello@skynettechnologies.com">hello@skynettechnologies.com</a>
                    </p>
                </section>
                
                
              

    
                <hr class="divider">
    
                <!-- Help Section -->
                <section class="help">
                    <p class="help-text">
                        <strong>Facing any issues with Accessibility
                            Scanning and Monitoring?</strong>
                        Report a problem, we will get back to you very soon!
                    </p>
                    <a href="https://www.skynettechnologies.com/report-accessibility-problem" class="help-btn" target="_blank">Report a
                        problem</a>
                </section>
    
            </div>
            
            </div>

        <br><br>
        <div id="section2" style="display:none;">
        <div class="accessibility-report">
            <div class="accessibility-score">
            	
                <div class="report-scan-wrapper">
                    <div class="report-date-section">
                        <label for="report-date">Report Date:</label>
                        <span class="report_date">
                            <?php 
                            if (!empty($last_scan)) {
                                echo esc_html(gmdate("F j, Y", strtotime($last_scan)));
                            } else {
                                echo 'No Date Available';
                            }
                            ?>
                        </span>
                    </div>
                    <div class="next-scan">
                        <strong>Next Scan on:</strong>
                        <?php 
                        if (!empty($next_scan_date)) {
                            echo esc_html(date_i18n('F j, Y', strtotime($next_scan_date)));
                        } else {
                            echo 'Not Scheduled';
                        }
                        ?>
                    </div>
                </div>
                

			<section class="top-section">
            	<div class="card score-card">
					<h3> Accessibility Score </h3>
                <div class="accessibility-score">
				<?php 
                // Default values
                $success_percentage = isset($success_percentage) ? floatval($success_percentage) : 0;
            
                // Determine status class
                if ($success_percentage >= 0 && $success_percentage < 50) {
                    $status_class = 'not-compliant';
                    $status_text  = esc_html__('Not Compliant', 'skynetaccessibility-scanner');
                } elseif ($success_percentage >= 50 && $success_percentage <= 85) {
                    $status_class = 'semi-compliant';
                    $status_text  = esc_html__('Semi Compliant', 'skynetaccessibility-scanner');
                } else {
                    $status_class = 'compliant';
                    $status_text  = esc_html__('Compliant', 'skynetaccessibility-scanner');
                }
                ?>
                
                <div class="score-value"><?php echo esc_html($success_percentage); ?>%</div>
                <span class="status-text <?php echo esc_attr($status_class); ?>">
                    <?php echo esc_html($status_text); ?>
                </span>
            </div>
            
            <div class="progress-bar">
                <div class="progress-fill" style="width: <?php echo esc_attr($success_percentage); ?>%;"></div>
            </div>
            
            <p class="note">
                <?php esc_html_e('Automated Accessibility score has limitations. We recommend Manual Accessibility Audit.', 'skynetaccessibility-scanner'); ?>
            </p>

            </div>
            
            
            <!-- Web Pages Scanned -->
            <div class="card pages-card">
                <h3>Web Pages Scanned</h3>
                <div class="pages-value">
                    <?php echo intval($total_scan_pages ?? 0); ?>
                </div>
                <div class="progress-bar">
                    <?php 
                    $scanProgress = (!empty($total_pages) && $total_pages > 0) 
                        ? ($total_scan_pages / $total_pages * 100) 
                        : 0;
                    ?>
                    <div class="progress-fill" style="width: <?php echo esc_attr($scanProgress); ?>%;"></div>
                </div>
                <p class="note">
                    <?php echo intval($total_scan_pages ?? 0); ?> pages scanned out of <?php echo intval($total_pages ?? 0); ?>
                </p>
            </div>

            </section>

            <!-- WCAG Section -->
            
            <section class="wcag-section">
               <div class="wcag-header">
                    <h3>WCAG 2.1/2.2</h3>
                    <button 
                        onclick="window.open('<?php echo esc_url($violationLink ? $violationLink : '#'); ?>', '_blank')"
                        
                        class="view-btn">
                        View all Violations 
                        <svg xmlns="http://www.w3.org/2000/svg" width="6" height="10" viewBox="0 0 6 10" fill="none">
                            <path
                                d="M6 5.00002C6 5.17924 5.92797 5.35843 5.78422 5.49507L1.25832 9.79486C0.970413 10.0684 0.503627 10.0684 0.21584 9.79486C-0.0719468 9.52145 -0.0719468 9.07807 0.21584 8.80452L4.22061 5.00002L0.21598 1.19549C-0.0718073 0.921968 -0.0718073 0.478632 0.21598 0.205242C0.503767 -0.0684128 0.970553 -0.0684128 1.25846 0.205242L5.78436 4.50496C5.92814 4.64166 6 4.82086 6 5.00002Z"
                                fill="white" />
                        </svg>
                    </button>
                </div>
                
                <?php if(empty($widget_purchased)){?>
                
                	 <!-- Checks Grid -->
                <div class="checks-grid">
                    <div class="check-card failed">
                        <span class="check-value">
                            <?php echo intval($scan_details['without_remediation']['total_fail'] ?? 0); ?>
                        </span>
                        <span class="check-label">Failed Checks</span>
                    </div>
                    <div class="check-card passed">
                        <span class="check-value">
                            <?php echo intval($scan_details['without_remediation']['total_success'] ?? 0); ?>
                        </span>
                        <span class="check-label">Passed Checks</span>
                    </div>
                    <div class="check-card na">
                        <span class="check-value">
                            <?php echo intval($scan_details['without_remediation']['severity_counts']['Not_Applicable'] ?? 0); ?>
                        </span>
                        <span class="check-label">N/A Checks</span>
                    </div>
                </div>


                <hr class="divider">

                <!-- Violations Grid -->
                <div class="violations-grid">
                    <div class="violation-card">
                        <span class="violation-title">Level A</span>
                        <span class="violation-count">
                            <span><?php echo intval($scan_details['without_remediation']['criteria_counts']['A'] ?? 0); ?></span>
                            violations
                        </span>
                    </div>
                
                    <div class="violation-card">
                        <span class="violation-title">Level AA</span>
                        <span class="violation-count">
                            <span><?php echo intval($scan_details['without_remediation']['criteria_counts']['AA'] ?? 0); ?></span>
                            violations
                        </span>
                    </div>
                
                    <div class="violation-card">
                        <span class="violation-title">Level AAA</span>
                        <span class="violation-count">
                            <span><?php echo intval($scan_details['without_remediation']['criteria_counts']['AAA'] ?? 0); ?></span>
                            violations
                        </span>
                    </div>
                </div>
                
                
                <?php }else{?>
                
                <!-- Checks Grid -->
                <div class="checks-grid">
                    <div class="check-card failed">
                        <span class="check-value">
                            <?php echo intval($scan_details['with_remediation']['total_fail'] ?? 0); ?>
                        </span>
                        <span class="check-label">Failed Checks</span>
                    </div>
                    <div class="check-card passed">
                        <span class="check-value">
                            <?php echo intval($scan_details['with_remediation']['total_success'] ?? 0); ?>
                        </span>
                        <span class="check-label">Passed Checks</span>
                    </div>
                    <div class="check-card na">
                        <span class="check-value">
                            <?php echo intval($scan_details['with_remediation']['severity_counts']['Not_Applicable'] ?? 0); ?>
                        </span>
                        <span class="check-label">N/A Checks</span>
                    </div>
                </div>


                <hr class="divider">

                <!-- Violations Grid -->
                <div class="violations-grid">
                    <div class="violation-card">
                        <span class="violation-title">Level A</span>
                        <span class="violation-count">
                            <span><?php echo intval($scan_details['with_remediation']['criteria_counts']['A'] ?? 0); ?></span>
                            violations
                        </span>
                    </div>
                
                    <div class="violation-card">
                        <span class="violation-title">Level AA</span>
                        <span class="violation-count">
                            <span><?php echo intval($scan_details['with_remediation']['criteria_counts']['AA'] ?? 0); ?></span>
                            violations
                        </span>
                    </div>
                
                    <div class="violation-card">
                        <span class="violation-title">Level AAA</span>
                        <span class="violation-count">
                            <span><?php echo intval($scan_details['with_remediation']['criteria_counts']['AAA'] ?? 0); ?></span>
                            violations
                        </span>
                    </div>
                </div>
               <?php }?>

            </section>
            <button class="back-btn" onclick="goBack()">Back</button>
        </div>
        
        </div>

        <br> <br>
        

    </div>
        </div>
    </div>
    </div>
    
    <?php
}
?>