   document.addEventListener("DOMContentLoaded", function () {
	  const toggle = document.getElementById("billing-toggle");
	  const monthlyLabel = document.getElementById("monthly-label");
	  const annualLabel = document.getElementById("annual-label");
	  const monthlyPlans = document.getElementById("monthlyclass");
	  const annualPlans = document.getElementById("annualclass");
	  const save20 = document.getElementById("save20");
	
	  function updateView(isAnnual) {
		if (isAnnual) {
		  // Show annual
		  monthlyPlans.style.display = "none";
		  annualPlans.style.display = "block";
		  monthlyLabel.classList.remove("active");
		  annualLabel.classList.add("active");
		  toggle.setAttribute("aria-pressed", "true");
		  toggle.setAttribute("aria-label", "Switch to Monthly Billing");
		  save20.style.opacity = "1";
		} else {
		  // Show monthly
		  monthlyPlans.style.display = "block";
		  annualPlans.style.display = "none";
		  annualLabel.classList.remove("active");
		  monthlyLabel.classList.add("active");
		  toggle.setAttribute("aria-pressed", "false");
		  toggle.setAttribute("aria-label", "Switch to Annual Billing");
		  save20.style.opacity = "0.45";
		}
	  }
	
	  function toggleBilling() {
		const isPressed = toggle.getAttribute("aria-pressed") === "true";
		updateView(!isPressed);
	  }
	
	  // Initial load
	  updateView(false); // default: monthly
	
	  // On button click
	  toggle.addEventListener("click", toggleBilling);
	  });
    
    // Hide and show violation report section function
    function showDetails() {
        
        document.getElementById("section1").style.display = "none";
        document.getElementById("section2").style.display = "block";
    }
    
    function goBack() {
        
        document.getElementById("section2").style.display = "none";
        document.getElementById("section1").style.display = "block";
    }
	
	function plan_is_expire() {
		alert("Subscription expired or canceled. Please renew your plan to view detailed reports.");
	}
    