<?php

/** 
 * Plugin Name: SKU Generator For Wc
 * Plugin URI:      https://wordpress.org/plugins/sku-generator-for-wc
* Description: Automatically generates SKUs for WooCommerce products (single & bulk).
 * Version: 1.0.0
 * Requires at least: 6.1
 * Requires PHP: 7.4
 * Author: tawkir
 * Author URI: 
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: sku-generator-for-wc
 * Requires Plugins: woocommerce
 * WC requires at least: 7.0
 * WC tested up to: 10.1.0
*/
if (! defined ('ABSPATH')) exit;
define ("SGFW_PLUGIN_PATH",plugin_dir_path(__FILE__));
require_once SGFW_PLUGIN_PATH . "includes/class-sku-generator.php";
add_action("plugins_loaded" , ["SGFW_sku_Generator" , "get_instance"]);

// WooCommerce check
add_action( 'admin_init', function() {
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', 'my_custom_wc_plugin_admin_notice' );
    }
});

/**
 * Admin notice if WooCommerce is not active.
 */
function my_custom_wc_plugin_admin_notice() {
    ?>
    <div class="notice notice-error is-dismissible">
        <p><strong>My Custom WooCommerce Plugin</strong> requires <a href="https://woocommerce.com/" target="_blank">WooCommerce</a> to be installed and active.</p>
    </div>
    <?php
}



?>