<?php
if(!defined("ABSPATH")) exit;
class SGFW_SKU_Generator {
    private static $instance = null;
    public static function get_instance(){
        if (self::$instance === null) self::$instance = new self();
        return self::$instance;
    }
    private function __construct(){
        add_action("save_post_product" , [$this, "auto_generate_sku_on_save"] , 10, 3);
        add_action("admin_menu" , [$this, "register_bulk_menu"]);
    }
    public function auto_generate_sku_on_save($post_id, $post, $update){
        if($post->post_type !== "product") return;
        $product = wc_get_product($post_id);
        if(!$product || $product->get_sku()) return;
        $sku = $this->generate_sku($product);
        $product->set_sku(sanitize_text_field($sku));
        $product->save();

    }
     /** 
     *     SKU Generation Logic
    */
    private function generate_sku($product){
        $product_id = $product->get_id();
        $product_cats = wp_get_post_terms( $product_id, 'product_cat' );
        if (is_array($product_cats) && !empty($product_cats)){
            $category_prefix = substr($product_cats[0]->name, 0, 3);
        }
        else { 
             $category_prefix = "NGJ";
        }
        $prefix = "PR" . $category_prefix . "-";
        return $prefix . $product->get_id();

    }
    /**
     * Add menu under Woocommerce
     */
    public function register_bulk_menu(){
        add_submenu_page(
            "woocommerce",
            esc_html__("Bulk SKU Generator","sku-generator-for-wc"),
            esc_html__("SKU Generator","sku-generator-for-wc"),
            "manage_woocommerce",
            "bulk-sku-generator",
            [ $this, "render_bulk_page"]
        );
    }
    /**
     * Render bulk SKU generation admin page
     */
    public function render_bulk_page(){
    if( isset ( $_POST["generate_skus"]) && check_admin_referer( "sgfw_generate_skus_action", "sgfw_nonce")){
            if(current_user_can("manage_woocommerce")){
                $this->generate_bulk_skus();
               echo '<div class=" notice notice-success is-dismissible"<p>' . esc_html__("Bulk SKU generation completed!", "sku-generator-for-wc") . '</p> </div>';
            }else{
                echo '<div class= "notice notice-error"<p>' . esc_html__("Permission denied.","sku-generator-for-wc") . '</p></div>';
            }
        }

        echo '<div class="wrap">';
        echo '<h2>' . esc_html__("Bulk SKU generator", "sku-generator-for-wc") . '</h2>';
        echo '<form method = "post">';
        wp_nonce_field("sgfw_generate_skus_action", "sgfw_nonce");
        submit_button( esc_html__("Generate SKUs for All Products", "sku-generator-for-wc"), "primary", "generate_skus");
        echo '</form></div>';

    }
    
    /**
     * Bulk generate SKUs for all products without one
     */
    private function generate_bulk_skus(){
        $args = [
            'post_type' => ['product','product_variation'],
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'fields' => 'ids',

        ];
        $product_ids = get_posts($args);

        foreach ($product_ids as $id){
            $product = wc_get_product($id);
            if($product && ! $product->get_sku() ){
              $sku = $this->generate_sku($product);
              $product ->set_sku( sanitize_text_field($sku));
              $product ->save();
            }
        }
    }
}

?>