<?php
/*
Plugin Name: SK-Elib
Description: This simple plugin takes care of the rest, with zero configuration. Transparent backgrounds work best. Crop it tight, with a width of 312 pixels, for best results.
Version: 1.0.2
License: GPL
Author: avdsystem
Author URI: https://open4u.ru
Text Domain: sk-elib

==========================================================================

Copyright (c) 2022 Ivan Molvinskikh (email: i.molvinskih@gmail.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/

class SK_ELIB {
	public static $instance;
	
	public function __construct() {
		self::$instance = $this;
		add_action('login_head', array( $this, 'login_head' ));
	}

	public function login_headerurl() {
		return esc_url(trailingslashit(get_bloginfo('url')));
	}

	public function login_headertitle() {
		return esc_attr(get_bloginfo('name'));
	}

	public function login_head() {
		add_filter('login_headerurl', array( $this, 'login_headerurl' ));
		add_filter(
			version_compare(get_bloginfo('version'), '5.2', '>=') ? 'login_headertext' : 'login_headertitle',
			array( $this, 'login_headertitle' )
		);
		
		$attachment_id = absint( get_theme_mod( 'custom_logo' ) );
		$logo_attributes  = wp_get_attachment_image_src($attachment_id , array(312,312) );
		if ( ! empty( $logo_attributes ) ){
		$logo_url = $logo_attributes[0];
		$logo_width = $logo_attributes[1];
		$logo_height = $logo_attributes[2];
		$logo_is_intermediate = $logo_attributes[3];
		
		?>
		<style>
			.login h1 a {
				background: url(<?php echo esc_url_raw( $logo_url ); ?>) no-repeat top center;
				width:  <?php echo absint($logo_width); ?>px;
				height: <?php echo absint($logo_height); ?>px;
				background-size: cover;
			}
		</style>
		<?php
		}
	}
}

// Bootstrap
new SK_ELIB;
