# Site Update Logger

Site Update Logger is a WordPress plugin that monitors and logs WordPress core and plugin updates, including errors, with a bilingual (English/Spanish) admin interface for log management.

Español: [Leer en Español](README.es.md)

Site Update Logger rastrea y registra actualizaciones del núcleo, plugins y temas de WordPress, incluidos errores, y ofrece una interfaz de administración bilingüe (inglés/español) para la gestión de registros.

## Features

- Tracks WordPress core, plugin, and theme updates (version changes)
- Monitors plugin and theme installation, activation, deactivation, and deletion
- Captures PHP errors, warnings, and notices during update processes
- Logs theme switching and activation events
- Logs are stored securely and organized by month
- Admin interface for viewing, downloading logs, and adding notes
- Month selector for filtering historical logs
- Automatic log rotation for large files
- Full bilingual support (English/Spanish)
- Secure actions with nonces, sanitization, and capability checks
- Configurable data deletion on uninstall - choose whether to keep or remove logs when deleting the plugin

## Installation

1. Upload the `site-update-logger` folder to `/wp-content/plugins/`
2. Activate the plugin through the WordPress admin panel
3. Access logs via the "Site Update Logger" menu in the admin sidebar

## Uninstallation

When you delete the plugin from WordPress, you have control over whether to remove the plugin data:

- **Settings Page**: Go to **Site Update Logger → Settings** to configure data deletion behavior
- **Data Deletion Option**: Check "Delete all plugin data (logs and settings) when the plugin is uninstalled" to automatically remove everything
- **Preserve Data**: If unchecked, log files will be preserved when you delete the plugin, allowing you to manually delete them later if needed

This gives you full control over your data when removing the plugin.

## Usage

- View logs and add notes from the admin page
- Filter logs by month using the month selector dropdown
- Download the current log file securely
- Configure data management settings from the Settings submenu
- All actions are protected with WordPress nonces and capability checks

## Settings

Access the settings page via **Site Update Logger → Settings** in the admin menu:

- **Data Management**: Choose whether to delete all plugin data (logs and settings) when the plugin is uninstalled
- If unchecked, log files will be preserved when you delete the plugin, allowing manual cleanup later

## Internationalization

- English and Spanish translations included
- To add more languages, edit the `.pot` file and create new `.po`/`.mo` files in the `languages` folder

## Security

- All admin actions use nonces and capability checks
- User input is sanitized and validated
- Log files are stored in the uploads directory under `site-update-logger/logs/`

## Support

For issues or feature requests, please contact the plugin author.
