# Publishing to WordPress.org (SVN)

This document contains exact commands to publish the plugin to the WordPress.org plugin repository using SVN. Run these commands from a machine with SVN installed. These examples assume your plugin slug is `site-update-logger` and your local repo root is the current working directory.

1. Prepare a clean copy for `trunk`

PowerShell example (from repo root):

```powershell
# Export current working tree to a temporary directory (no .git)
$tmp = Join-Path $env:TEMP "site-update-logger-publish"
Remove-Item -Recurse -Force $tmp -ErrorAction SilentlyContinue
New-Item -ItemType Directory -Path $tmp | Out-Null
robocopy . $tmp /E /XF ".git\*" ".github\*" "tools\*" "tests\*" "node_modules\*" "*.ps1" /NFL /NDL /NJH /NJS
Set-Location $tmp
```

2. Check out the WordPress.org SVN repo (replace your username)

```powershell
svn checkout https://plugins.svn.wordpress.org/site-update-logger/ site-update-logger-svn
```

3. Copy files into `trunk` and add/remove files

```powershell
robocopy $tmp\ site-update-logger-svn\trunk /MIR
Set-Location site-update-logger-svn\trunk
svn add --force * --auto-props --parents --depth infinity -q
svn status --no-ignore
```

4. Commit to SVN

```powershell
svn commit -m "Release version x.y.z"
```

5. Tagging a release (create a copy to `tags/x.y.z`)

```powershell
Set-Location ..\
svn copy trunk tags\x.y.z
svn commit -m "Tagging version x.y.z"
```

Notes

- Ensure `readme.txt` is the WordPress.org canonical readme and `Text Domain` matches your plugin slug.
- Add compiled `.mo` files to `languages/` if you want them included; translate.wordpress.org will provide translations automatically when the plugin is hosted on WordPress.org.
- If you change the main plugin file name, WordPress.org will treat it as a new plugin — prefer keeping the main file name the same for upgrades.
