<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class Sirapix_WC_POS_Shortcode {

    public static function init() {
        add_shortcode( 'sirapix_wc_pos', [ __CLASS__, 'render' ] );
    }

    public static function render( $atts = [] ) {
        // Auth gate
        if ( ! is_user_logged_in() ) {
            return self::render_login();
        }
        if ( ! sirapix_wc_pos_user_has_access() ) {
            return self::render_no_permission();
        }

        // Add a body class to allow hiding theme header/footer on POS page
        add_filter( 'body_class', function( $classes ) {
            if ( ! in_array( 'sirapix-pos-page', $classes, true ) ) {
                $classes[] = 'sirapix-pos-page';
            }
            return $classes;
        } );

        ob_start();
        $items_per_row = (int) get_option( 'sirapix_wc_pos_items_per_row', 4 );
        if ( $items_per_row < 2 ) { $items_per_row = 2; }
        if ( $items_per_row > 8 ) { $items_per_row = 8; }
        $home_url      = home_url( '/' );
        $dashboard_url = admin_url();
        $settings_url  = admin_url( 'admin.php?page=sirapix-wc-pos' );
        $logout_url    = wp_logout_url( $home_url );
        ?>
        <div class="sirapix-pos-wrapper" style="--spx-items-per-row: <?php echo esc_attr( $items_per_row ); ?>;">
            <div class="sirapix-pos-header">
                <h1 class="sirapix-pos-inline-title"><?php echo esc_html( get_bloginfo('name') . ' POS' ); ?></h1>
                <div class="spx-header-right">
                    <div class="spx-net-status"><span id="spx-net-text" class="spx-net-text"></span><span id="spx-net-dot" class="spx-net-dot" title=""></span></div>
                    <div class="spx-queue-status" id="spx-queue-ui">
                        <span id="spx-queue-count-label" class="spx-queue-label"><?php esc_html_e( 'Queued orders:', 'sirapix-pos-for-woocommerce' ); ?> <strong id="spx-queue-count">0</strong></span>
                        <button type="button" id="spx-sync-now" class="sirapix-btn secondary spx-sync-btn">
                            <span class="spx-sync-label"><?php esc_html_e( 'Sync Now', 'sirapix-pos-for-woocommerce' ); ?></span>
                        </button>
                    </div>
                    <button type="button" id="spx-refund-btn" class="sirapix-btn secondary spx-refund-btn" title="<?php esc_attr_e( 'Refunds / Orders', 'sirapix-pos-for-woocommerce' ); ?>">
                        <span class="spx-refund-icon" aria-hidden="true">
                            <svg fill="currentColor" viewBox="0 0 193.769 193.769" xmlns="http://www.w3.org/2000/svg" width="18" height="18" role="img" focusable="false">
                                <g>
                                    <g>
                                        <g>
                                            <path d="M149.203,41.104l-9.348,12.009c20.15,15.679,30.201,41.063,26.234,66.253c-2.906,18.484-12.838,34.73-27.964,45.748 c-15.131,11.012-33.64,15.488-52.124,12.567c-38.157-6.008-64.32-41.938-58.322-80.098C30.585,79.097,40.52,62.85,55.648,51.835 c13.208-9.615,28.991-14.233,45.086-13.317L87.579,52.319l9.759,9.313l20.766-21.801l0.005,0.008l9.303-9.769l-9.752-9.303 l-0.005,0.003L95.862,0l-9.31,9.769l14.2,13.525c-19.303-0.913-38.21,4.702-54.059,16.242C28.28,52.943,16.19,72.717,12.65,95.221 c-7.302,46.445,24.54,90.184,70.985,97.493c4.489,0.708,8.976,1.055,13.434,1.055c17.89,0,35.273-5.623,50.011-16.356 c18.415-13.409,30.503-33.183,34.043-55.682C185.952,91.077,173.72,60.181,149.203,41.104z" />
                                            <path d="M105.24,151.971v-0.003h0.001v-8.757c10.383-1.159,20.485-7.718,20.485-20.17c0-16.919-15.732-18.859-27.223-20.274 c-7.347-0.878-12.97-1.897-12.97-6.348c0-6.188,8.722-6.855,12.473-6.855c5.567,0,11.507,2.617,13.525,5.957l0.586,0.971 l11.542-5.341l-0.571-1.164c-4.301-8.793-12.009-11.337-17.85-12.364v-7.71H91.723v7.677 c-12.582,1.856-20.054,8.839-20.054,18.829c0,16.29,14.791,17.943,25.582,19.153c9.617,1.134,14.094,3.51,14.094,7.469 c0,7.563-10.474,8.154-13.685,8.154c-7.147,0-14.038-3.566-16.031-8.301l-0.495-1.169l-12.539,5.316l0.5,1.169 c3.713,8.691,11.725,14.137,22.63,15.425v8.336H105.24z" />
                                        </g>
                                    </g>
                                </g>
                            </svg>
                        </span>
                    </button>
                </div>
            </div>
            
            <div class="sirapix-pos-customer">
                <div class="sirapix-customer-row">
                    <div class="sirapix-field"><label><?php esc_html_e( 'Customer Phone', 'sirapix-pos-for-woocommerce' ); ?></label><input type="text" id="spx-customer-phone" /></div>
                    <div class="sirapix-field"><label><?php esc_html_e( 'Customer Name', 'sirapix-pos-for-woocommerce' ); ?></label><input type="text" id="spx-customer-name" /></div>
                    <div class="sirapix-field"><label><?php esc_html_e( 'Customer Email', 'sirapix-pos-for-woocommerce' ); ?></label><input type="email" id="spx-customer-email" placeholder="name@example.com" /></div>
                </div>
            </div>

            <div class="sirapix-pos-shell">
                <aside class="sirapix-pos-sidebar">
                    <a href="<?php echo esc_url( $home_url ); ?>" class="spx-side-icon spx-side-home" title="<?php esc_attr_e( 'View website', 'sirapix-pos-for-woocommerce' ); ?>"></a>
                    <a href="<?php echo esc_url( $dashboard_url ); ?>" class="spx-side-icon spx-side-dashboard" title="<?php esc_attr_e( 'WordPress Dashboard', 'sirapix-pos-for-woocommerce' ); ?>"></a>
                    <a href="<?php echo esc_url( $settings_url ); ?>" class="spx-side-icon spx-side-settings" title="<?php esc_attr_e( 'POS Settings', 'sirapix-pos-for-woocommerce' ); ?>"></a>
                    <a href="<?php echo esc_url( $logout_url ); ?>" class="spx-side-icon spx-side-logout" title="<?php esc_attr_e( 'Log out', 'sirapix-pos-for-woocommerce' ); ?>"></a>
                </aside>
                <div class="sirapix-pos-main">
            <div class="sirapix-pos-layout">
                <div class="sirapix-pos-col sirapix-pos-col-middle">
                    <div class="sirapix-panel">
                        <div class="sirapix-panel-title"><?php esc_html_e( 'Categories', 'sirapix-pos-for-woocommerce' ); ?></div>
                        <div id="spx-categories" class="sirapix-categories"></div>
                    </div>
                </div>
                <div class="sirapix-pos-col sirapix-pos-col-right">
                    <div class="sirapix-panel">
                        <div class="sirapix-panel-title with-search">
                            <?php esc_html_e( 'Products', 'sirapix-pos-for-woocommerce' ); ?>
                            <input type="text" id="spx-search" placeholder="Search products..." minlength="2" />
                        </div>
                        <div id="spx-products" class="sirapix-products"></div>
                        <div id="spx-products-sentinel"></div>
                    </div>
                </div>
                <div class="sirapix-pos-col sirapix-pos-col-cart">
                    <div class="sirapix-panel">
                        <div class="sirapix-panel-title">
                            <div class="sirapix-title-left">
                                <span id="spx-cart-title-label"><?php esc_html_e( 'Current Order: ', 'sirapix-pos-for-woocommerce' ); ?></span>
                                <strong id="spx-title-total">0</strong>
                            </div>
                            <span id="spx-cart-count" class="sirapix-count-badge" style="display:none;">0</span>
                        </div>
                        <div class="sirapix-cart-actions" style="margin-top:8px;">
                            <button id="spx-complete-top" class="sirapix-btn primary"><?php esc_html_e( 'Complete Order', 'sirapix-pos-for-woocommerce' ); ?></button>
                            <button id="spx-clear-top" class="sirapix-btn secondary"><?php esc_html_e( 'Clear', 'sirapix-pos-for-woocommerce' ); ?></button>
                        </div>
                        <div class="sirapix-cart">
                            <div class="sirapix-cart-items" id="spx-cart-items"></div>
                            <div class="sirapix-cart-summary">
                                <div><span><?php esc_html_e( 'Subtotal', 'sirapix-pos-for-woocommerce' ); ?></span><strong id="spx-subtotal">0</strong></div>
                                <div><span><?php esc_html_e( 'Tax', 'sirapix-pos-for-woocommerce' ); ?></span><strong id="spx-tax">0</strong></div>
                                <div><span><?php esc_html_e( 'Total', 'sirapix-pos-for-woocommerce' ); ?></span><strong id="spx-total">0</strong></div>
                            </div>
                            <div class="sirapix-cart-actions">
                                <button id="spx-clear" class="sirapix-btn secondary"><?php esc_html_e( 'Clear', 'sirapix-pos-for-woocommerce' ); ?></button>
                                <div class="sirapix-payment-select">
                                    <label>
                                        <input type="radio" name="spx-payment" value="pos_offline" checked /> <?php esc_html_e( 'Offline Payment', 'sirapix-pos-for-woocommerce' ); ?>
                                    </label>
                                </div>
                                <div class="sirapix-override">
                                    <label for="spx-override-total" style="display:block;font-size:12px;opacity:.8;">Apply discounted total (optional)</label>
                                    <input type="number" step="0.01" id="spx-override-total" placeholder="0.00" />
                                </div>
                                <div class="sirapix-origin">
                                    <label style="display:block;font-size:12px;opacity:.8;">Purchase Origin</label>
                                    <div class="sirapix-payment-select" style="display:flex; gap:12px; align-items:center;">
                                        <label>
                                            <input type="radio" name="spx-origin" value="in_store" checked /> In-Store
                                        </label>
                                        <label>
                                            <input type="radio" name="spx-origin" value="phone" /> Phone
                                        </label>
                                    </div>
                                </div>
                                <button id="spx-complete" class="sirapix-btn primary"><?php esc_html_e( 'Complete Order', 'sirapix-pos-for-woocommerce' ); ?></button>
                                <button id="spx-print" class="sirapix-btn secondary" disabled><?php esc_html_e( 'Print Receipt', 'sirapix-pos-for-woocommerce' ); ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    public static function render_login() {
        $redirect = get_permalink( (int) get_option( 'sirapix_wc_pos_page_id' ) );
        ob_start();
        ?>
        <div class="sirapix-pos-login">
            <?php 
            $logo_rel  = 'assets/images/sirapix-login-logo.png';
            $logo_path = trailingslashit( SIRAPIX_WC_POS_PLUGIN_DIR ) . $logo_rel;
            $logo_url  = trailingslashit( SIRAPIX_WC_POS_PLUGIN_URL ) . $logo_rel;
            if ( file_exists( $logo_path ) ) : ?>
                <img class="sirapix-login-logo" src="<?php echo esc_url( $logo_url ); ?>" alt="SIRAPIX" />
            <?php endif; ?>
            <?php /* translators: %s: site name. */ ?>
            <h2><?php echo esc_html( sprintf( __( 'Login to %s POS', 'sirapix-pos-for-woocommerce' ), get_bloginfo('name') ) ); ?></h2>
            <?php wp_login_form( [ 'redirect' => esc_url( $redirect ) ] ); ?>
            
        </div>
        <?php
        return ob_get_clean();
    }

    public static function render_no_permission() {
        ob_start();
        ?>
        <div class="sirapix-pos-noaccess">
            <p><?php esc_html_e( 'You do not have permission to access the POS.', 'sirapix-pos-for-woocommerce' ); ?></p>
        </div>
        <?php
        return ob_get_clean();
    }
}

Sirapix_WC_POS_Shortcode::init();
