<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class Sirapix_WC_POS_Onboarding {

    public static function init() {
        add_action( 'template_redirect', [ __CLASS__, 'maybe_render' ] );
    }

    public static function maybe_render() {
        if ( is_admin() ) {
            return;
        }
        if ( ! isset( $_GET['sirapix_pos_onboarding'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
            return;
        }
        self::render_page();
        exit;
    }

    public static function render_page() {
        if ( ! is_user_logged_in() || ! current_user_can( 'manage_woocommerce' ) ) {
			wp_die( esc_html__( 'You do not have permission to access this page.', 'sirapix-pos-for-woocommerce' ) );
        }

        $page_id   = (int) get_option( 'sirapix_wc_pos_page_id' );
        $pos_url   = $page_id ? get_permalink( $page_id ) : home_url( '/sirapix-pos/' );
        $rest_url  = esc_url( rest_url( 'sirapix-pos/v1/static/products' ) );
        $nonce     = wp_create_nonce( 'wp_rest' );
        $lottie_js = SIRAPIX_WC_POS_PLUGIN_URL . 'assets/js/lottie.min.js';
        $lottie_json = SIRAPIX_WC_POS_PLUGIN_URL . 'assets/images/duotone-thumbs-up-illustration-2025-10-20-04-28-30-utc.json';

        nocache_headers();
        header( 'Cache-Control: no-store' );

        $title = get_bloginfo( 'name' ) . ' POS Onboarding';

        $onb_css = "\n" .
            '.sirapix-onb-shell { display:flex; margin:0 auto; max-width:100%; height: 100vh; background:#f3f4f6; border-radius:12px; overflow:hidden; border:1px solid #e5e7eb; }' . "\n" .
            '.sirapix-onb-left { flex:1 1 50%; padding:10vh 80px; background:#ffffff; box-sizing:border-box; }' . "\n" .
            '.sirapix-onb-right { flex:1 1 50%; padding:10vh 80px; background:#e0f2fe; display:flex; align-items:center; justify-content:center; box-sizing:border-box; }' . "\n" .
            '.sirapix-onb-progress { width:100%; height:6px; border-radius:999px; background:#e5f0ff; overflow:hidden; margin-bottom:32px; }' . "\n" .
            '.sirapix-onb-content { margin: 10vh 0 0 0; }' . "\n" .
            '.sirapix-onb-progress-fill { height:100%; width:40%; border-radius:999px; background:#0ea5e9; transition: width 600ms ease; }' . "\n" .
            '.sirapix-onb-title { font-size:26px; margin:0 0 12px; }' . "\n" .
            '.sirapix-onb-sub { margin:0 0 18px; color:#6b7481; max-width:520px; font-size:14px; }' . "\n" .
            '.sirapix-onb-list { margin:0 0 24px 18px; padding:0; color:#4b5563; }' . "\n" .
            '.sirapix-onb-list li { margin-bottom:6px; }' . "\n" .
            '.sirapix-onb-body { margin: 5vh 0; }' . "\n" .
            '.sirapix-onb-footer { display:flex; align-items:center; justify-content:flex-end; gap:12px; margin:20vh 0 0 0; }' . "\n" .
            '.sirapix-onb-btn { min-width:160px; padding:10px 26px; font-size:14px; border-radius: 30px; border: 0; background: #0EA5E9; color: white; cursor:pointer; transition: background-color 0.15s ease; }' . "\n" .
            '.sirapix-onb-btn:hover { background:#0284c7; }' . "\n" .
            '.sirapix-onb-status { font-size:16px; color:#4b5563; margin-top:36px; text-align:center; max-width:640px; margin-left:auto; margin-right:auto; }' . "\n" .
            '.sirapix-onb-graphic { width:100%; max-width:500px; min-height:220px; display:flex; flex-direction:column; align-items:center; justify-content:center; color:#0f172a; font-size:14px; text-align:center; padding:24px; box-sizing:border-box; gap:18px; }' . "\n" .
            '.sirapix-onb-visual-block { width:100%; }' . "\n" .
            '.sirapix-onb-credit, .sirapix-onb-credit-fixed { display:inline-flex; align-items:center; gap:6px; font-size:11px; color:#4b5563; text-decoration:none; opacity:0.9; }' . "\n" .
            '.sirapix-onb-credit:hover, .sirapix-onb-credit-fixed:hover { opacity:1; text-decoration:underline; }' . "\n" .
            '#sirapix-onb-lottie { width:100%; max-width:320px; height:220px; margin:0 auto; }' . "\n" .
            '@media (max-width: 960px) { .sirapix-onb-shell { flex-direction:column; } .sirapix-onb-left, .sirapix-onb-right { width:100%; padding:24px 20px; } .sirapix-onb-progress { width:100%; } }' . "\n";

        $onb_js = "(function(){\n" .
            "var btn = document.getElementById('sirapix-onb-btn');\n" .
            "var statusEl = document.getElementById('sirapix-onb-status');\n" .
            "var bar = document.querySelector('.sirapix-onb-progress-fill');\n" .
            "var welcomeGraphic = document.getElementById('sirapix-onb-graphic-welcome');\n" .
            "var doneGraphic = document.getElementById('sirapix-onb-graphic-done');\n" .
            "var lottieContainer = document.getElementById('sirapix-onb-lottie');\n" .
            "if (!btn || !bar) { return; }\n" .
            'var restUrl = ' . wp_json_encode( $rest_url ) . ';' . "\n" .
            'var nonce = ' . wp_json_encode( $nonce ) . ';' . "\n" .
            'var posUrl = ' . wp_json_encode( $pos_url ) . ';' . "\n" .
            'var lottieJson = ' . wp_json_encode( $lottie_json ) . ';' . "\n" .
            "function setStatus(msg, isError) {\n" .
            "  if (!statusEl) return;\n" .
            "  statusEl.textContent = msg || '';\n" .
            "  statusEl.style.color = isError ? '#b91c1c' : '#4b5563';\n" .
            "}\n" .
            "function animateTo(percent) {\n" .
            "  var clamped = Math.max(0, Math.min(100, percent));\n" .
            "  bar.style.width = clamped + '%';\n" .
            "}\n" .
            "function startGeneration(){\n" .
            "  if (btn.getAttribute('data-state') === 'done') { window.location.href = posUrl; return; }\n" .
            "  btn.disabled = true;\n" .
            '  btn.textContent = ' . wp_json_encode( __( 'Generating offline data...', 'sirapix-pos-for-woocommerce' ) ) . ';' . "\n" .
            '  setStatus(' . wp_json_encode( __( 'Please keep this tab open while we generate products JSON.', 'sirapix-pos-for-woocommerce' ) ) . ');' . "\n" .
            "  animateTo(60);\n" .
            "  fetch(restUrl, {\n" .
            "    method: 'POST',\n" .
            "    headers: {\n" .
            "      'X-WP-Nonce': nonce,\n" .
            "      'Content-Type': 'application/json'\n" .
            "    }\n" .
            "  }).then(function(res){\n" .
            "    if (!res.ok) { throw new Error('HTTP ' + res.status); }\n" .
            "    return res.json().catch(function(){ return {}; });\n" .
            "  }).then(function(){\n" .
            "    animateTo(100);\n" .
            "    setTimeout(function(){\n" .
            "      if (welcomeGraphic && doneGraphic) { welcomeGraphic.style.display = 'none'; doneGraphic.style.display = 'flex'; }\n" .
            "      var lottieApi = (typeof window.lottie !== 'undefined' && window.lottie) ? window.lottie : (typeof window.bodymovin !== 'undefined' ? window.bodymovin : null);\n" .
            "      if (lottieApi && lottieContainer && lottieJson) {\n" .
            "        try {\n" .
            "          lottieApi.loadAnimation({ container: lottieContainer, renderer: 'svg', loop: 2, autoplay: true, path: lottieJson });\n" .
            "        } catch (e) {}\n" .
            "      }\n" .
            "      btn.disabled = false;\n" .
            "      btn.setAttribute('data-state', 'done');\n" .
            '      btn.textContent = ' . wp_json_encode( __( 'Go to POS', 'sirapix-pos-for-woocommerce' ) ) . ';' . "\n" .
            '      setStatus(' . wp_json_encode( __( 'Offline data generated. You can now start using the POS.', 'sirapix-pos-for-woocommerce' ) ) . ');' . "\n" .
            "    }, 700);\n" .
            "  }).catch(function(err){\n" .
            "    btn.disabled = false;\n" .
            '    btn.textContent = ' . wp_json_encode( __( 'Continue', 'sirapix-pos-for-woocommerce' ) ) . ';' . "\n" .
            "    animateTo(40);\n" .
            '    setStatus(' . wp_json_encode( __( 'Failed to generate offline data. Please try again or run sync from POS Settings.', 'sirapix-pos-for-woocommerce' ) ) . ", true);\n" .
            "    console.error('SIRAPIX POS onboarding error', err);\n" .
            "  });\n" .
            "}\n" .
            "btn.addEventListener('click', startGeneration);\n" .
            "})();";

        $onb_style_handle  = 'sirapix-pos-onboarding-inline';
        $onb_script_handle = 'sirapix-pos-onboarding-inline-js';

        if ( ! wp_style_is( $onb_style_handle, 'registered' ) ) {
            wp_register_style( $onb_style_handle, false, [], null );
        }
        wp_enqueue_style( $onb_style_handle );
        wp_add_inline_style( $onb_style_handle, $onb_css );

        if ( ! wp_script_is( $onb_script_handle, 'registered' ) ) {
            wp_register_script( $onb_script_handle, '', [], null, true );
        }
        wp_enqueue_script( $onb_script_handle );
        wp_add_inline_script( $onb_script_handle, $onb_js, 'after' );
        ?>
        <!doctype html>
        <html <?php language_attributes(); ?>>
        <head>
            <meta charset="<?php echo esc_attr( get_bloginfo( 'charset' ) ); ?>" />
            <meta name="viewport" content="width=device-width, initial-scale=1" />
            <title><?php echo esc_html( $title ); ?></title>
            <?php
            ob_start();
            wp_print_styles( $onb_style_handle );
            $onb_styles = ob_get_clean();
            if ( $onb_styles ) {
                $spx_allowed_tags = [
                    'link'  => [
                        'rel'   => true,
                        'href'  => true,
                        'id'    => true,
                        'media' => true,
                        'type'  => true,
                    ],
                    'style' => [
                        'id'    => true,
                        'media' => true,
                        'type'  => true,
                    ],
                ];
                echo wp_kses( $onb_styles, $spx_allowed_tags );
            }
            ?>
        </head>
        <body style="margin:0; padding:0px; background:#e5e7eb; font-family:-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;">
        <div id="sirapix-pos-onboarding-root" style="margin:0; max-width:none;">
            <div class="sirapix-onb-shell">
                <div class="sirapix-onb-left">
                    <div class="sirapix-onb-progress">
                        <div class="sirapix-onb-progress-fill" data-step="1"></div>
                    </div>
                    <div class="sirapix-onb-content">
                        <h2 class="sirapix-onb-title"><?php esc_html_e( 'Welcome to SIRAPIX POS', 'sirapix-pos-for-woocommerce' ); ?></h2>
                        <p class="sirapix-onb-sub">
                            <?php esc_html_e( 'Transform WooCommerce into a powerful, easy-to-use checkout system.', 'sirapix-pos-for-woocommerce' ); ?>
                        </p>
                        <div class="sirapix-onb-body">
                            <p><?php esc_html_e( 'We’ll quickly configure the plugin for maximum speed and reliability. This setup takes just a few minutes and ensures smooth operation.', 'sirapix-pos-for-woocommerce' ); ?></p>
                            <p><?php esc_html_e( 'Your data stays safe and private during setup.', 'sirapix-pos-for-woocommerce' ); ?></p>
                        </div>
                        <div class="sirapix-onb-footer">
                            <button type="button" class="button button-primary sirapix-onb-btn" id="sirapix-onb-btn">
                                <?php esc_html_e( 'Continue', 'sirapix-pos-for-woocommerce' ); ?>
                            </button>
                        </div>
                    </div>
                </div>
                <div class="sirapix-onb-right">
                    <div class="sirapix-onb-graphic sirapix-onb-graphic-welcome" id="sirapix-onb-graphic-welcome">
                        <div class="sirapix-onb-visual-block">
                            <img src="<?php echo esc_url( SIRAPIX_WC_POS_PLUGIN_URL . 'assets/images/VNU_M735_7-min.png' ); ?>" alt="<?php esc_attr_e( 'SIRAPIX POS onboarding illustration', 'sirapix-pos-for-woocommerce' ); ?>" style="max-width:100%; height:auto; display:block;" />
                        </div>
                    </div>
                    <div class="sirapix-onb-graphic sirapix-onb-graphic-done" id="sirapix-onb-graphic-done" style="display:none;">
                        <div class="sirapix-onb-visual-block">
                            <div id="sirapix-onb-lottie" aria-hidden="true"></div>
                            <p class="sirapix-onb-status" id="sirapix-onb-status"></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        // Register + enqueue the onboarding Lottie script, then print just that handle.
        $onb_handle = 'sirapix-pos-onboarding-lottie';
        if ( ! wp_script_is( $onb_handle, 'registered' ) ) {
            wp_register_script( $onb_handle, $lottie_js, [], null, true );
        }
        wp_enqueue_script( $onb_handle );

        ob_start();
        wp_print_scripts( [ $onb_handle, $onb_script_handle ] );
        $onb_script_tag = ob_get_clean();
        if ( $onb_script_tag ) {
            $spx_allowed_script_tag = [
                'script' => [
                    'src'            => true,
                    'id'             => true,
                    'type'           => true,
                    'async'          => true,
                    'defer'          => true,
                    'nomodule'       => true,
                    'crossorigin'    => true,
                    'integrity'      => true,
                    'referrerpolicy' => true,
                    'data-*'         => true,
                ],
            ];

            $sanitized = preg_replace_callback(
                '/<script\b[^>]*>.*?<\/script>/is',
                function( $m ) use ( $spx_allowed_script_tag ) {
                    if ( ! preg_match( '/^(<script\b[^>]*>)(.*?)(<\/script>)$/is', $m[0], $parts ) ) {
                        return '';
                    }
                    $open  = wp_kses( $parts[1], $spx_allowed_script_tag );
                    $body  = $parts[2];
                    $close = '</script>';
                    return $open . $body . $close;
                },
                $onb_script_tag
            );

            echo $sanitized; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
        }
        ?>
        </body>
        </html>
        <?php
    }
}

Sirapix_WC_POS_Onboarding::init();
