<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class Sirapix_WC_POS_Activator {

    public static function activate() {
        // Ensure page exists
        $page_id = (int) get_option( 'sirapix_wc_pos_page_id', 0 );
        $shortcode = '[sirapix_wc_pos]';
        $existing = get_post( $page_id );
        if ( ! $existing ) {
            // Try to find by path 'sirapix-pos'
            $by_path = get_page_by_path( 'sirapix-pos', OBJECT, 'page' );
            if ( $by_path ) {
                $page_id = (int) $by_path->ID;
            }
        }

        if ( $page_id && get_post( $page_id ) ) {
            // Update content and slug if needed
            $content = get_post_field( 'post_content', $page_id );
            $update = [ 'ID' => $page_id ];
            if ( strpos( (string) $content, $shortcode ) === false ) {
                $update['post_content'] = $shortcode;
            }
            $post_name = get_post_field( 'post_name', $page_id );
            if ( $post_name !== 'sirapix-pos' ) {
                $update['post_name'] = 'sirapix-pos';
            }
            if ( count( $update ) > 1 ) { wp_update_post( $update ); }
        } else {
            $page_id = wp_insert_post( [
                'post_title'   => wp_strip_all_tags( get_bloginfo( 'name' ) . ' POS' ),
                'post_name'    => 'sirapix-pos',
                'post_content' => $shortcode,
                'post_status'  => 'publish',
                'post_type'    => 'page',
            ] );
        }

        if ( $page_id && ! is_wp_error( $page_id ) ) {
            update_option( 'sirapix_wc_pos_page_id', (int) $page_id );
        }

        // Default allowed roles
        if ( get_option( 'sirapix_wc_pos_allowed_roles', null ) === null ) {
            update_option( 'sirapix_wc_pos_allowed_roles', [ 'administrator', 'shop_manager' ] );
        }

        update_option( 'sirapix_wc_pos_do_activation_redirect', 1 );
    }

    public static function deactivate() {
        // Keep page and settings by default
    }
}
