<?php

/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 04.04.2017
 * Time: 8:30
 */

use SinglePosts\Components\SinglePostsHtmlHelper;

if ( ! defined( 'POST_VIEWS_PATH' ) ) {
	die();
}


if ( $shortcode_mgr->get_boolean( 'titles_only' ) ) {
	$title_class = 'single-posts-post-titles-only';
} else {
	$title_class = 'single-posts-posttitle';
}


$temp = sanitize_quotes( $shortcode_mgr->get( 'wrap_title_start' ) );
$html .= htmlspecialchars_decode( $temp );

/*

 * This code creates title link

 */
$title_color        = $shortcode_mgr->get( 'title_color' );

if( $shortcode_mgr->has_value( 'title_length' ) ){
	$title_length = intval( $shortcode_mgr->get( 'title_length' ) );
	$title = single_posts_strip_text_words( $the_post['post_title'], $title_length );
} else {
	$title_length_chars = intval( $shortcode_mgr->get( 'title_length_characters' ) );
	$title = ShortenText( $the_post['post_title'], $title_length_chars );
}
$title_style = 'color: ' . $title_color . ';';

if ( $shortcode_mgr->get_boolean( 'include_link_title' ) ) {

	if ( !isset( $exclude_title_links) || ! array_has_value( $the_post['ID'], $exclude_title_links ) ) {
		$html .= SinglePostsHtmlHelper::create_link($the_post['guid'], $title, $open_link_in_new_tab, 'single-posts-posttitle-link');
	} else {
		$html .= SinglePostsHtmlHelper::create_span($title, $title_class, $title_style );
	}

} else {
	$html .= SinglePostsHtmlHelper::create_span($title, $title_class, $title_style );
}
$html .= htmlspecialchars_decode( $shortcode_mgr->get( 'wrap_title_end' ) );