<?php

/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 04.04.2017
 * Time: 8:10
 */

use SinglePosts\Components\SinglePostsHtmlHelper;

if ( ! defined( 'POST_VIEWS_PATH' ) ) {

	die();

}

if( $shortcode_mgr->get_boolean( 'show_title' ) ){
	include 'title.php';
}

$date_post = '';

if( $shortcode_mgr->has_value( 'date_format' ) ){
	$format = $shortcode_mgr->get( 'date_format' );
	if( $format === 'settings' ){
		$format = get_option( 'date_format' );
	}
}
else{
	$format = 'M j';
}

if ( array_key_exists( 'post_date', $the_post ) ) {

	$date = new DateTime( trim( $the_post['post_date'] ) );

	$date_post = date_i18n( $format, $date->getTimestamp() );
}

$meta_width = $shortcode_mgr->get( 'meta_width' );


if ( $meta_width == "100%" ) {

	$width = 'width: 100%;';

} else {

	$width = "width: " . $meta_width . "px;";

}
if ( ! $shortcode_mgr->get_boolean( 'hide_source' ) ) {
	$html .= '<div class="single-posts-source" style="margin-bottom: 5px;' . $width . '">';

	if ( $shortcode_mgr->get_boolean( 'meta_info' ) ) {

		$html .= '<span>' . __( 'Published', 'SinglePosts' ) . '</span><span>' . ' ' . $date_post . '' . '</span>' . ' ' . '<span>' . __( 'in', 'SinglePosts' ) . '</span>'
		         . '  <span>' . SinglePostsHtmlHelper::create_link( $blog_url, $blog_name, $open_link_in_new_tab ) . '</span><br/>';

	}
	if ( $shortcode_mgr->get_boolean( 'show_order' ) ) {
		if ( isset( $tab_order_by1 ) && count( $tab_order_by1 ) > 0 && isset( $the_post[ $tab_order_by1[0] ] ) ) {
			$fieldname = $tab_order_by1[0];
			$fullname  = single_posts_create_label_from_id( $fieldname );
			$html      .= "<span>" . $fullname . ": " . $the_post[ $tab_order_by1[0] ] . "</span><br/>";
		}
	}
	$show_date   = false;
	$date_column = '';

	if( $shortcode_mgr->has_value( 'exclude_all_past_events' ) ){
		$show_date = true;
		$date_column = $shortcode_mgr->get( 'exclude_all_past_events' );
	}
	if( $shortcode_mgr->has_value( 'show_past_events' ) ){
		$show_date = true;
		$date_column = $shortcode_mgr->get( 'show_past_events' );
	}

	if ( $shortcode_mgr->has_value( 'show_before_date' ) ) {
		$show_date   = true;
		$data = $shortcode_mgr->split_array( 'show_before_date', '::' );
		$date_column = $data[0];
	}
	if ( $shortcode_mgr->has_value( 'show_after_date' ) ) {
		$show_date   = true;
		$data = $shortcode_mgr->split_array( 'show_after_date', '::' );
		$date_column = $data[0];
	}
	if ( $shortcode_mgr->has_value( 'show_for_today' ) ) {
		$show_date   = true;
		$date_column = $shortcode_mgr->get( 'show_for_today' );
	}

	if ( $show_date && isset( $the_post[ $date_column ] ) ) {
		$date = new DateTime( $the_post[ $date_column ] );
		$date = date_i18n( $format, $date->getTimestamp() );
		if( $shortcode_mgr->get_boolean( 'add_link_to_date' ) ){
			$date = SinglePostsHtmlHelper::create_link( $the_post['guid'], $date );
		}
		$html .= SinglePostsHtmlHelper::create_span( $date ) . '<br/>';
	}

##  Full metadata

	if ( $shortcode_mgr->get_boolean( 'show_author' ) ) {

		if ( $column > 1 ) {

			$html .= '<br />';

		}

		$author_display_name = get_the_author_meta( 'display_name', $the_post['post_author'] );
		$author_url          = get_author_posts_url( $the_post['post_author'] );
		$html                .= SinglePostsHtmlHelper::create_author_link( $author_url, $author_display_name, $open_link_in_new_tab );

	}
	$html .= '</div>'; //end of single-posts-source
}

if( $shortcode_mgr->get_boolean( 'show_categories' ) ) {
	if ( isset( $the_post['categories'] ) ) {

		$html .= '<div class="single-posts-categories" style="margin-bottom: 5px; ' . $width . '">';
		foreach ( $the_post['categories'] as $category ) {
			$category_name = $category->name;
			if( $shortcode_mgr->get_boolean( 'show_category_icon' ) ){
				$category_name = '<span class="icon ic-category"></span>' . $category_name;
			}
			if( $the_post['post_type'] === 'product' ) {
				$html .= SinglePostsHtmlHelper::create_term_link( $category->term_id, $category_name, $open_link_in_new_tab );
			} else {
				$html .= SinglePostsHtmlHelper::create_term_link( $category->term_id, $category_name, $open_link_in_new_tab );
			}
		}
		$html .= '</div>';
	}
}

if( $shortcode_mgr->has_value( 'show_custom_taxonomies' ) ){
	$custom_categories = $the_post['custom_taxonomies'];
	if( ! empty( $custom_categories ) ){
		$html .= '<div class="single-posts-custom-taxonomies" style="margin-bottom: 5px; ' . $width . '">';
		foreach ( $custom_categories as $category ){
			$category_name = $category->name;
			if( $shortcode_mgr->get_boolean( 'show_custom_taxonomy_icon' ) ){
				$category_name = '<span class="icon ic-custom-taxonomy"></span>' . $category_name;
			}
			$html        .= SinglePostsHtmlHelper::create_link( $category->url, $category_name, $open_link_in_new_tab );
		}
		$html .= '</div>';
	}
}

if( $shortcode_mgr->get_boolean( 'show_tags' ) ) {
	if ( isset( $the_post['terms'] ) ) {

		$html .= '<div class="single-posts-terms" style="margin-bottom: 5px; ' . $width . '">';
		foreach ( $the_post['terms'] as $term ) {
			if( $shortcode_mgr->get_boolean( 'show_tag_icon' ) ){
				$term->name = '<span class="icon ic-tag"></span>' . $term->name;
			}
			if( $the_post['post_type'] === 'product' ){
				$html .= SinglePostsHtmlHelper::create_term_link( $term->term_id, $term->name, $open_link_in_new_tab );
			} else {
				$html .= SinglePostsHtmlHelper::create_term_link( $term->term_id, $term->name, $open_link_in_new_tab );
			}
		}
		$html .= '</div>';
	}
}
if( $shortcode_mgr->has_value( 'include_post_meta' ) ){
	$meta_keys = $shortcode_mgr->split_array( 'include_post_meta', ',' );

	// Remove acf fields from meta
	if( $shortcode_mgr->has_value( 'include_acf_fields' ) ){
		$acf_fields = $shortcode_mgr->split_array( 'include_acf_fields', ',' );
		$meta_keys = array_diff( $meta_keys, $acf_fields );
	}
	$text = apply_filters( 'single_posts_get_meta_html', $the_post, $meta_keys );
	$html .= '<div class="single-posts-extra-meta">';
	if( is_string( $text ) ){
		$html .= $text;
	}
	else{
		foreach ($meta_keys as $key){
			if( isset( $the_post[$key] ) ) {
				$html .= '<span><span class="post-meta-key">' . $key . '</span>: <span class="post-meta-value">' . $the_post[ $key ] . '</span></span>';
			}
		}
	}
	$html .= '</div>';
}

if( $shortcode_mgr->has_value( 'include_acf_fields' ) ) {
	if ( function_exists( 'get_field_objects' ) ) {
		$fields = get_field_objects( $the_post['ID'], array( 'format_value' => true, 'load_value' => true ) );
		if ( $fields ) {
			$fields_result = array();
			if ( $shortcode_mgr->get_boolean( 'include_acf_fields' ) ) {
				$filter_fields = array_keys( $fields );
			} else {
				$filter_fields = $shortcode_mgr->split_array( 'include_acf_fields', ',' );
			}

			if( $shortcode_mgr->has_value( 'add_link_to_acf' ) ){
				$add_link_to_acf = $shortcode_mgr->split_array( 'add_link_to_acf', ',' );
			}
			else{
				$add_link_to_acf = array();
			}

			foreach ( $fields as $name => $field ) {
				if ( in_array( $name, $filter_fields ) ) {
					if( $field['type'] === 'date_picker' &&
						$shortcode_mgr->has_value( 'acf_date_format' ) ){
						$date = date_create_from_format( $field['return_format'], $field['value'] );
						$value = $date->format( $shortcode_mgr->get( 'acf_date_format' ) );
					}
					else{
						$value = $field['value'];
					}
					if( in_array( $name, $add_link_to_acf ) ){
						$value = SinglePostsHtmlHelper::create_link( $the_post['guid'], $value );
					}
					$fields_result[ $name ] = array( 'label' => $field['label'], 'value' => $value );
				}
			}

			$text = apply_filters( 'single_posts_get_acf_html', $fields_result, $the_post );

			$html .= '<div class="single-posts-acf-fields">';
			if ( is_string( $text ) ) {
				$html .= $text;
			} else {
				foreach ( $fields_result as $name => $field ) {
					$label = $field['label'];
					$value = $field['value'];
					if ( is_string( $value ) ) {
						if ( $shortcode_mgr->get_boolean( 'hide_acf_labels' ) ) {
							$html .= '<span class="acf-value">' . $value . '</span>';
						} else {
							$html .= '<span><span class="acf-label">' . $label . '</span><span class="acf-label-colon">:</span> <span class="acf-value">' . $value . '</span></span>';
						}
					} elseif ( is_array( $value ) ) {
						$str = '';
						if ( is_array( $value[0] ) ) {
							$str = join( $value, ', ' );
						} elseif ( $value[0] instanceof WP_Post ) {
							$str = '';
							foreach ( $value as $inner_post ) {
								$str .= $inner_post->post_title . ', ';
							}
							$str = mb_substr( $str, 0, - 2 );
						}
						if ( $shortcode_mgr->get_boolean( 'hide_acf_labels' ) ) {
							$html .= '<span>' . $str . '</span>';
						} else {
							$html .= '<span>' . $name . '<span class="acf-label-colon">:</span> ' . $str . '</span>';
						}
					}
				}
			}
			$html .= '</div>';
		}
	}
}

if( $shortcode_mgr->get_boolean( 'show_rating' ) ) {
	if ( $the_post['rating'] ) {
		$html .= '<div class="br-wrapper br-theme-fontawesome-stars">';
        $html .= '<div class="br-widget">';
		for ( $i = 1; $i <= $the_post['rating']; $i ++ ) {
			$html .= '<a class="br-selected"></a>';
		}
		$html .= '</div>';
		$html .= '</div>';
	}
}
