<?php

/**
 * Created by PhpStorm.
 * User: Admin
 * Date: 04.04.2017
 * Time: 8:10
 */

use SinglePosts\Components\SinglePostsHtmlHelper;

if ( ! defined( 'POST_VIEWS_PATH' ) ) {

	die();

}


$wrap_text_start = sanitize_quotes( $shortcode_mgr->get( 'wrap_text_start' ) );

$text_color = $shortcode_mgr->get( 'text_color' );

$auto_excerpt = $shortcode_mgr->get_boolean( 'auto_excerpt' );

$excerpt_length = $shortcode_mgr->get( 'excerpt_length' );

$excerpt_letters_length = $shortcode_mgr->get( 'excerpt_letters_length' );

$full_text = $shortcode_mgr->get_boolean( 'full_text' );

$manual_excerpt_length = $shortcode_mgr->get( 'manual_excerpt_length' );

$manual_excerpt_letters_length = $shortcode_mgr->get( 'manual_excerpt_letters_length' );

$filter_excerpt = $shortcode_mgr->get_boolean( 'filter_excerpt' );

$use_shortcode_in_excerpt = $shortcode_mgr->get_boolean( 'use_shortcode_in_excerpt' );


$wrap_excerpt_start = sanitize_quotes( $shortcode_mgr->get( 'wrap_excerpt_start' ) );

$wrap_excerpt_end = $shortcode_mgr->get( 'wrap_excerpt_end' );

$wrap_text_end = $shortcode_mgr->get( 'wrap_text_end' );


$html .= htmlspecialchars_decode( $wrap_text_start );

$html .= '<div class="single-posts-excerpt" style="color: ' . $text_color . ';">';


if ( $auto_excerpt || ! $the_post['post_excerpt'] ) {

	if ( $excerpt_length ) {

		$exerpt = get_words_excerpt( $excerpt_length, $the_post['post_content'], $the_post['guid'], $filter_excerpt );

	} else if ( $excerpt_letters_length ) {

		$exerpt = get_letters_excerpt( $excerpt_letters_length, $the_post['post_content'], $the_post['guid'], $filter_excerpt );

	}

} else {

	$exerpt = $the_post['post_excerpt'];

}

if ( $use_shortcode_in_excerpt ) {

	if ( $exerpt ) {

		$exerpt = do_shortcode( $exerpt );

	}

}

if ( $filter_excerpt ) {

	if ( $exerpt ) {

		$exerpt = apply_filters( 'the_excerpt', $exerpt );

	}

}

if ( $full_text ) {

	$text = $the_post['post_content'];

	$text = do_shortcode( $text );
	$text = single_posts_remove_pagination( $text );

} else {

	if ( $manual_excerpt_length ) {

		$text = get_words_excerpt( $manual_excerpt_length, $the_post['post_excerpt'], $the_post['guid'], $filter_excerpt );

	} else if ( $manual_excerpt_letters_length ) {

		$text = get_letters_excerpt( $manual_excerpt_letters_length, $the_post['post_excerpt'], $the_post['guid'], $filter_excerpt );

	} else {

		$text = $exerpt;
	}

}

if ( ! $shortcode_mgr->get_boolean( 'hide_excerpt' ) ) {
	$html .= htmlspecialchars_decode( $wrap_excerpt_start );

	$html .= strip_shortcodes( $text );

	$html .= htmlspecialchars_decode( $wrap_excerpt_end );
}
$show_link = true;

$hide_all_links = get_option( 'hide_all_readmore_links' );

if ( empty( $hide_all_links ) || $hide_all_links == false ) {

	$pages_string = get_option( 'hide_readmore_link_pages' );

	$pages_without_readmore_link = array();

	$title = $the_post['post_title'];

	if ( ! empty( $pages_string ) > 0 ) {

		$pages_without_readmore_link = explode( ';', $pages_string );

		foreach ( $pages_without_readmore_link as $item ) {

			if ( trim( strtolower( $title ) ) == trim( strtolower( $item ) ) ) {

				$show_link = false;

			}

		}

	}

	if ( $show_link ) {
		if( $shortcode_mgr->has_value( 'read_more_text' ) ){
			$link_text = $shortcode_mgr->get( 'read_more_text' );
		}
		else{
			$link_text = __( 'read more', 'SinglePosts' ) . '&nbsp;&#10095;';
		}
		$html .= SinglePostsHtmlHelper::create_link( $the_post['guid'],
			$link_text,
			$open_link_in_new_tab,
			'single-posts-read-more-link'
		);
	}

}

$html .= '</div>';//end of single-posts-excerpt
$html .= htmlspecialchars_decode( $wrap_text_end );