<?php

// Exit if accessed directly.
if (!defined('ABSPATH')) exit;

/*
Plugin Name: Single Post View Counter
Description: A simple plugin to count and display post views on bottom of post detail page.
Version: 1.0.0
Author: Virendra Yadav
Author URI: https://wpblogwala.in/
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

// Function to track post views
function why_pvc_set_post_views($postID) {
    // Get the current view count
    $postID = absint($postID);
    $views = get_post_meta($postID, 'pvc_post_views', true);

    $views = absint($views);
    // Update view count
    if ($views == '') {
        $views = 0;
        delete_post_meta($postID, 'pvc_post_views');
        add_post_meta($postID, 'pvc_post_views', '1');
    } 
    else 
    {
        $views++;
        update_post_meta($postID, 'pvc_post_views', $views);
    }
}

// Hook into WordPress to count views only for single posts
function why_pvc_track_post_views($post_id) {
    if (!is_single()) return;
    if (empty($post_id)) {
        global $post;
        $post_id = $post->ID;
    }
    why_pvc_set_post_views($post_id);
}
add_action('wp_head', 'why_pvc_track_post_views');

// Function to retrieve post views
function why_pvc_get_post_views($postID) {
    $views = get_post_meta($postID, 'pvc_post_views', true);
    return $views ? $views : '0';
}

// Display post views at the end of the content
function why_pvc_display_post_views($content) {
    if (is_single()) {
        global $post;
        $views = why_pvc_get_post_views($post->ID);
        $content .= '<p><strong>Post Views:</strong> ' . $views . '</p>';
    }
    return $content;
}
add_filter('the_content', 'why_pvc_display_post_views');