<?php
/**
 * Simply SEO Uninstall
 *
 * Removes all plugin data when uninstalled.
 *
 * @package Simply_SEO
 * @since 1.0.0
 */

// Exit if accessed directly or not uninstalling
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

// Check if user wants to keep data
$simply_seo_settings = get_option( 'simply_seo_settings', array() );
if ( ! empty( $simply_seo_settings['keep_data_on_uninstall'] ) ) {
    // User wants to keep data, exit without deleting anything
    return;
}

// Delete options
delete_option( 'simply_seo_settings' );
delete_option( 'simply_seo_db_version' );

// Delete all post meta using WordPress functions
$simply_seo_post_meta_keys = array(
    '_simply_seo_title',
    '_simply_seo_description',
    '_simply_seo_keywords',
    '_simply_seo_noindex',
    '_simply_seo_nofollow',
    '_simply_seo_canonical',
    '_simply_seo_social_image',
);

foreach ( $simply_seo_post_meta_keys as $simply_seo_meta_key ) {
    delete_post_meta_by_key( $simply_seo_meta_key );
}

// Delete all term meta using WordPress functions
$simply_seo_term_meta_keys = array(
    '_simply_seo_title',
    '_simply_seo_description',
    '_simply_seo_noindex',
    '_simply_seo_nofollow',
    '_simply_seo_image',
);

// Get all terms and delete meta
$simply_seo_taxonomies = get_taxonomies( array( 'public' => true ), 'names' );
foreach ( $simply_seo_taxonomies as $simply_seo_taxonomy ) {
    $simply_seo_terms = get_terms( array(
        'taxonomy'   => $simply_seo_taxonomy,
        'hide_empty' => false,
        'fields'     => 'ids',
    ) );
    
    if ( ! is_wp_error( $simply_seo_terms ) && ! empty( $simply_seo_terms ) ) {
        foreach ( $simply_seo_terms as $simply_seo_term_id ) {
            foreach ( $simply_seo_term_meta_keys as $simply_seo_term_key ) {
                delete_term_meta( $simply_seo_term_id, $simply_seo_term_key );
            }
        }
    }
}

// Drop redirects table
global $wpdb;
$simply_seo_table_name = esc_sql( $wpdb->prefix . 'simply_seo_redirects' );
// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching, WordPress.DB.DirectDatabaseQuery.SchemaChange, WordPress.DB.PreparedSQL.InterpolatedNotPrepared
$wpdb->query( "DROP TABLE IF EXISTS `{$simply_seo_table_name}`" );

// Clear any cached data
wp_cache_flush();
