/**
 * Simply SEO Redirects Scripts
 *
 * @package Simply_SEO
 * @since 1.0.6
 */

(function($) {
    'use strict';

    $(document).ready(function() {

        // Add new redirect
        $('#simply-seo-add-redirect').on('submit', function(e) {
            e.preventDefault();
            
            var $form = $(this);
            var $button = $form.find('button[type="submit"]');
            var $status = $form.find('.simply-seo-status');
            
            $button.prop('disabled', true);
            $status.text(simplySeoRedirects.saving).removeClass('error success');

            $.ajax({
                url: simplySeoRedirects.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'simply_seo_save_redirect',
                    nonce: simplySeoRedirects.nonce,
                    from: $('#redirect-from').val(),
                    to: $('#redirect-to').val(),
                    type: $('#redirect-type').val()
                },
                success: function(response) {
                    if (response.success) {
                        $status.text(simplySeoRedirects.saved).addClass('success');
                        
                        // Add row to table or reload
                        location.reload();
                    } else {
                        $status.text(response.data.message || simplySeoRedirects.error).addClass('error');
                    }
                },
                error: function() {
                    $status.text(simplySeoRedirects.error).addClass('error');
                },
                complete: function() {
                    $button.prop('disabled', false);
                    setTimeout(function() {
                        $status.text('');
                    }, 3000);
                }
            });
        });

        // Delete redirect
        $(document).on('click', '.simply-seo-delete-redirect', function(e) {
            e.preventDefault();
            
            if (!confirm(simplySeoRedirects.confirmDelete)) {
                return;
            }
            
            var $row = $(this).closest('tr');
            var id = $row.data('id');
            
            $.ajax({
                url: simplySeoRedirects.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'simply_seo_delete_redirect',
                    nonce: simplySeoRedirects.nonce,
                    id: id
                },
                success: function(response) {
                    if (response.success) {
                        $row.fadeOut(300, function() {
                            $(this).remove();
                            
                            // Show empty message if no more redirects
                            if ($('#simply-seo-redirects-table tbody tr').length === 0) {
                                location.reload();
                            }
                        });
                    } else {
                        alert(response.data.message || simplySeoRedirects.error);
                    }
                },
                error: function() {
                    alert(simplySeoRedirects.error);
                }
            });
        });

        // Toggle redirect enabled/disabled
        $(document).on('change', '.simply-seo-redirect-toggle', function() {
            var $toggle = $(this);
            var $row = $toggle.closest('tr');
            var id = $row.data('id');
            var enabled = $toggle.is(':checked');
            
            $.ajax({
                url: simplySeoRedirects.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'simply_seo_toggle_redirect',
                    nonce: simplySeoRedirects.nonce,
                    id: id,
                    enabled: enabled
                },
                success: function(response) {
                    if (!response.success) {
                        // Revert toggle on error
                        $toggle.prop('checked', !enabled);
                        alert(response.data.message || simplySeoRedirects.error);
                    }
                },
                error: function() {
                    $toggle.prop('checked', !enabled);
                    alert(simplySeoRedirects.error);
                }
            });
        });

    });

})(jQuery);
