/**
 * Simply SEO Admin Scripts
 *
 * @package Simply_SEO
 * @since 1.0.1
 */

(function($) {
    'use strict';

    $(document).ready(function() {
        
        // ======================
        // Settings Page - Default Image
        // ======================
        var settingsMediaUploader;

        $('#simply-seo-select-image').on('click', function(e) {
            e.preventDefault();

            if (settingsMediaUploader) {
                settingsMediaUploader.open();
                return;
            }

            settingsMediaUploader = wp.media({
                title: simplySeoAdmin.selectImage || 'Select Image',
                button: { text: simplySeoAdmin.useImage || 'Use this image' },
                multiple: false,
                library: { type: 'image' }
            });

            settingsMediaUploader.on('select', function() {
                var attachment = settingsMediaUploader.state().get('selection').first().toJSON();
                $('#simply-seo-default-image').val(attachment.id);
                $('#simply-seo-image-preview').html('<img src="' + attachment.url + '" alt="">');
                $('#simply-seo-remove-image').show();
            });

            settingsMediaUploader.open();
        });

        $('#simply-seo-remove-image').on('click', function(e) {
            e.preventDefault();
            $('#simply-seo-default-image').val('0');
            $('#simply-seo-image-preview').html('');
            $(this).hide();
        });

        // ======================
        // Settings Page - Breadcrumbs Icon Toggle
        // ======================
        $('#simply-seo-breadcrumbs-home-icon').on('change', function() {
            if ($(this).is(':checked')) {
                $('#simply-seo-home-text-row').hide();
                $('#simply-seo-home-icon-preview').css('display', 'flex');
            } else {
                $('#simply-seo-home-text-row').show();
                $('#simply-seo-home-icon-preview').hide();
            }
        });

        // ======================
        // Taxonomy Page - Social Image
        // ======================
        var taxonomyMediaUploader;

        $('.simply-seo-tax-select-image').on('click', function(e) {
            e.preventDefault();
            
            if (taxonomyMediaUploader) {
                taxonomyMediaUploader.open();
                return;
            }
            
            taxonomyMediaUploader = wp.media({
                title: simplySeoAdmin.selectImage || 'Select Image',
                button: { text: simplySeoAdmin.useImage || 'Use this image' },
                multiple: false,
                library: { type: 'image' }
            });
            
            taxonomyMediaUploader.on('select', function() {
                var attachment = taxonomyMediaUploader.state().get('selection').first().toJSON();
                $('#simply-seo-tax-image').val(attachment.id);
                $('#simply-seo-tax-image-preview').html('<img src="' + attachment.url + '" style="max-width:200px;height:auto;">');
                $('.simply-seo-tax-remove-image').show();
            });
            
            taxonomyMediaUploader.open();
        });

        $('.simply-seo-tax-remove-image').on('click', function(e) {
            e.preventDefault();
            $('#simply-seo-tax-image').val('');
            $('#simply-seo-tax-image-preview').html('');
            $(this).hide();
        });

        // ======================
        // Classic Editor - Social Image
        // ======================
        var classicMediaUploader;

        $('#simply-seo-select-social-image').on('click', function(e) {
            e.preventDefault();
            
            if (classicMediaUploader) {
                classicMediaUploader.open();
                return;
            }
            
            classicMediaUploader = wp.media({
                title: simplySeoAdmin.selectSocialImage || 'Select Social Image',
                button: { text: simplySeoAdmin.useImage || 'Use this image' },
                multiple: false,
                library: { type: 'image' }
            });
            
            classicMediaUploader.on('select', function() {
                var attachment = classicMediaUploader.state().get('selection').first().toJSON();
                $('#simply-seo-social-image').val(attachment.id);
                $('#simply-seo-social-image-preview').html('<img src="' + attachment.url + '" style="max-width:300px;height:auto;margin-top:10px;">');
                $('#simply-seo-remove-social-image').show();
            });
            
            classicMediaUploader.open();
        });

        $('#simply-seo-remove-social-image').on('click', function(e) {
            e.preventDefault();
            $('#simply-seo-social-image').val('');
            $('#simply-seo-social-image-preview').html('');
            $(this).hide();
        });

    });

})(jQuery);
