import { registerBlockType } from '@wordpress/blocks';
import { RichText, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, ToggleControl } from '@wordpress/components';
import { __ } from '@wordpress/i18n';

registerBlockType('simple-true-false-quiz/question', {
    attributes: {
        question: {
            type: 'string',
            source: 'html',
            selector: '.stfq-question'
        },
        isTrue: {
            type: 'boolean',
            default: false
        },
        allowMultipleAttempts: {
            type: 'boolean',
            default: true
        }
    },

    edit: ({ attributes, setAttributes }) => {
        const { question, isTrue, allowMultipleAttempts } = attributes;

        return (
            <>
                <InspectorControls>
                    <PanelBody title={__('Quiz Settings', 'simple-true-false-quiz')}>
                        <ToggleControl
                            label={__('Correct Answer', 'simple-true-false-quiz')}
                            help={isTrue ? __('The statement is true', 'simple-true-false-quiz') : __('The statement is false', 'simple-true-false-quiz')}
                            checked={isTrue}
                            onChange={() => setAttributes({ isTrue: !isTrue })}
                            __nextHasNoMarginBottom={true}
                        />
                        <ToggleControl
                            label={__('Allow Multiple Attempts', 'simple-true-false-quiz')}
                            help={allowMultipleAttempts ? __('Users can try multiple times', 'simple-true-false-quiz') : __('Users can only try once', 'simple-true-false-quiz')}
                            checked={allowMultipleAttempts}
                            onChange={() => setAttributes({ allowMultipleAttempts: !allowMultipleAttempts })}
                            __nextHasNoMarginBottom={true}
                        />
                    </PanelBody>
                </InspectorControls>
                <div className={`wp-block-simple-true-false-quiz editor ${isTrue ? 'true' : 'false'}`}>
                    <RichText
                        tagName="div"
                        className="stfq-question"
                        value={question}
                        onChange={(question) => setAttributes({ question })}
                        placeholder={__('Enter your true/false question here...', 'simple-true-false-quiz')}
                    />
                </div>
            </>
        );
    },

    save: ({ attributes }) => {
        // We need this to store the content in the database
        const { question } = attributes;
        return (
            <div>
                <div className="stfq-question">
                    <RichText.Content
                        tagName="div"
                        value={question}
                    />
                </div>
            </div>
        );
    }
}); 