document.addEventListener('DOMContentLoaded', () => {
    console.log('STFQ Frontend Script Loaded');
    
    const quizBlocks = document.querySelectorAll('.wp-block-simple-true-false-quiz');
    console.log('Found quiz blocks:', quizBlocks.length);

    quizBlocks.forEach(block => {
        const isTrue = block.dataset.isTrue === '1';
        const allowMultiple = block.dataset.multipleAttempts === '1';
        const feedback = block.querySelector('.stfq-feedback');
        let isAnswered = false;

        function resetQuiz() {
            feedback.classList.remove('show', 'correct', 'incorrect');
            isAnswered = false;
            feedback.innerHTML = '';
        }

        function showFeedback(isCorrect) {
            console.log('Showing feedback:', isCorrect);
            
            const message = isCorrect 
                ? block.dataset.correctMessage 
                : block.dataset.incorrectMessage;
            
            feedback.innerHTML = message;
            
            // Show reset button if multiple attempts are allowed (regardless of correct/incorrect)
            if (allowMultiple) {
                feedback.innerHTML += `
                    <button type="button" class="stfq-reset" aria-label="${block.dataset.resetLabel}">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" width="24" height="24">
                            <path d="M17.65 6.35A7.958 7.958 0 0 0 12 4c-4.42 0-7.99 3.58-7.99 8s3.57 8 7.99 8c3.73 0 6.84-2.55 7.73-6h-2.08A5.99 5.99 0 0 1 12 18c-3.31 0-6-2.69-6-6s2.69-6 6-6c1.66 0 3.14.69 4.22 1.78L13 11h7V4l-2.35 2.35z"/>
                        </svg>
                    </button>
                `;
                
                // Add click handler for reset button
                const resetButton = feedback.querySelector('.stfq-reset');
                if (resetButton) {
                    resetButton.addEventListener('click', resetQuiz);
                }
            }
            
            feedback.classList.add('show');
            feedback.classList.toggle('correct', isCorrect);
            feedback.classList.toggle('incorrect', !isCorrect);
            
            isAnswered = true;
        }

        block.querySelectorAll('.stfq-icon').forEach(button => {
            button.addEventListener('click', (e) => {
                if (isAnswered) return;

                const selectedTrue = e.currentTarget.classList.contains('true');
                showFeedback(selectedTrue === isTrue);
            });
        });
    });
}); 