<?php
/*
Plugin Name: Simple Sticky TOC
Description: Lightweight, customizable sticky Table of Contents with RTL support, mobile toggle, and theme overrides.
Version: 1.0.1
Author: Pavlo Bondarchuk
Author URI: https://github.com/pavlo-bondarchuk
License: GPLv2 or later
License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/



if (!defined('ABSPATH'))
    exit;

define('bonddesign_sstoc_VERSION', '1.0.');
define('bonddesign_sstoc_PATH', plugin_dir_path(__FILE__));
define('bonddesign_sstoc_URL', plugin_dir_url(__FILE__));

// Load frontend functionality
if (!is_admin()) {
    require_once bonddesign_sstoc_PATH . 'frontend/assets.php';
    require_once bonddesign_sstoc_PATH . 'frontend/render.php';
}

// Load admin panel
if (is_admin()) {
    require_once bonddesign_sstoc_PATH . 'admin/settings-page.php';
    require_once bonddesign_sstoc_PATH . 'admin/metabox.php';
}


register_activation_hook(__FILE__, 'bonddesign_sstoc_activate');
register_deactivation_hook(__FILE__, 'bonddesign_sstoc_deactivate');

function bonddesign_sstoc_activate()
{
    $default_options = [
        'heading_depth' => 'h2-h4',
    ];

    if (get_option('bonddesign_sstoc_options') === false) {
        add_option('bonddesign_sstoc_options', $default_options);
    }
}

function bonddesign_sstoc_deactivate()
{
    // Nothing for now – we preserve options for future re-activation
}

