<?php

if (!defined('ABSPATH'))
    exit;

add_filter('the_content', 'bonddesign_sstoc_prepend_toc_to_content');

function bonddesign_sstoc_prepend_toc_to_content($content)
{
    if (!is_singular() || !in_the_loop() || !is_main_query())
        return $content;
    if (get_post_meta(get_the_ID(), '_bonddesign_sstoc_disable', true))
        return $content;

    $toc = '<div id="content-wrapper">';
    $toc .= '<div class="simple-sticky-toc-wrapper">';
    $toc .= bonddesign_sstoc_get_toc_html();
    $toc .= '</div>';
    $toc .= '<div id="sstoc-content">' . $content . '</div>';
    $toc .= '</div>';

    return $toc;
}

function bonddesign_sstoc_get_toc_html()
{
    ob_start();

    $template_path = locate_template('simple-sticky-toc/toc-template.php');

    if ($template_path) {
        include $template_path;
    } else {
        include bonddesign_sstoc_PATH . 'frontend/partials/toc-template.php';
    }

    return ob_get_clean();
}

