<?php

if (!defined('ABSPATH'))
    exit;

add_action('wp_enqueue_scripts', 'bonddesign_sstoc_enqueue_assets');

function bonddesign_sstoc_enqueue_assets()
{
    if (!is_singular() || !is_main_query())
        return;

    // Check for theme override CSS
    $theme_css = get_stylesheet_directory() . '/simple-sticky-toc/toc.css';
    $theme_css_url = get_stylesheet_directory_uri() . '/simple-sticky-toc/toc.css';

    if (file_exists($theme_css)) {
        wp_enqueue_style('sstoc-style', $theme_css_url, [], filemtime($theme_css));
    } else {
        wp_enqueue_style(
            'sstoc-style',
            bonddesign_sstoc_URL . 'assets/css/toc.css',
            [],
            bonddesign_sstoc_VERSION
        );
    }

    // Check for theme override JS
    $theme_js = get_stylesheet_directory() . '/simple-sticky-toc/toc.js';
    $theme_js_url = get_stylesheet_directory_uri() . '/simple-sticky-toc/toc.js';

    if (file_exists($theme_js)) {
        wp_enqueue_script('sstoc-script', $theme_js_url, [], filemtime($theme_js), true);
    } else {
        wp_enqueue_script(
            'sstoc-script',
            bonddesign_sstoc_URL . 'assets/js/toc.js',
            [],
            bonddesign_sstoc_VERSION,
            true
        );
    }

    $options = get_option('bonddesign_sstoc_options');
    $depth = $options['heading_depth'] ?? 'h2-h4';

    $selector = match ($depth) {
        'h2' => 'h2',
        'h2-h3' => 'h2, h3',
        default => 'h2, h3, h4',
    };

    wp_localize_script('sstoc-script', 'sstocData', [
        'headingsSelector' => $selector,
        'isRTL' => is_rtl(),
    ]);
}
