document.addEventListener("DOMContentLoaded", function () {
  const selector = window.sstocData?.headingsSelector || "h2, h3, h4";
  const tocList = document.querySelector(".sstoc-list");
  const content = document.querySelector("#sstoc-content");

  if (!content || !tocList) return;

  const headings = Array.from(content.querySelectorAll(selector));
  if (!headings.length) return;

  // ID & anchor creation
  headings.forEach((heading, i) => {
    if (!heading.id) heading.id = "toc-" + i;
  });

// Build nested TOC (safe)
  let currentList = tocList;
  let lastLevel = 2;
  const levelMap = { H2: 2, H3: 3, H4: 4 };
  const parents = [tocList];

  headings.forEach((heading) => {
    const level = levelMap[heading.tagName] || 2;

    const li = document.createElement("li");
    const a = document.createElement("a");
    a.href = "#" + heading.id;
    a.textContent = heading.textContent;
    li.appendChild(a);

    if (level === lastLevel) {
      currentList.appendChild(li);
    } else if (level > lastLevel) {
      const parentLi = currentList.lastElementChild;
      if (!parentLi) {
        currentList.appendChild(li);
      } else {
        const ul = document.createElement("ul");
        parentLi.appendChild(ul);
        ul.appendChild(li);
        parents.push(ul);
        currentList = ul;
        lastLevel = level;
        return;
      }
    } else {
      while (parents.length > 1 && lastLevel > level) {
        parents.pop();
        lastLevel--;
      }
      currentList = parents[parents.length - 1] || tocList;
      currentList.appendChild(li);
    }

    lastLevel = level;
  });

  // Scroll spy
  const links = tocList.querySelectorAll("a");
  const observerOptions = {
    rootMargin: "0px 0px -80% 0px",
    threshold: 0,
  };

  const observer = new IntersectionObserver((entries) => {
    entries.forEach((entry) => {
      const id = entry.target.id;
      const link = tocList.querySelector(`a[href="#${id}"]`);

      if (link) {
        if (entry.isIntersecting) {
          links.forEach((l) => l.classList.remove("active"));
          link.classList.add("active");
        }
      }
    });
  }, observerOptions);

  headings.forEach((heading) => observer.observe(heading));

  // Toggle menu on mobile
  const toggleBtn = document.querySelector(".sstoc-toggle");
  if (toggleBtn && tocList) {
    toggleBtn.addEventListener("click", () => {
      tocList.classList.toggle("open");
    });

    tocList.querySelectorAll("a").forEach((link) => {
      link.addEventListener("click", () => {
        tocList.classList.remove("open");
      });
    });
  }
});
