<?php

if (!defined('ABSPATH'))
    exit;

add_action('admin_menu', 'bonddesign_sstoc_add_settings_page');
add_action('admin_init', 'bonddesign_sstoc_register_settings');

function bonddesign_sstoc_add_settings_page()
{
    add_menu_page(
        'Simple Sticky TOC',
        'Simple Sticky TOC',
        'manage_options',
        'simple-sticky-toc',
        'bonddesign_sstoc_render_settings_page',
        'dashicons-list-view',
        90
    );
}

function bonddesign_sstoc_register_settings()
{
    register_setting('bonddesign_sstoc_settings', 'bonddesign_bonddesign_sstoc_options', 'bonddesign_bonddesign_sstoc_sanitize_options');

    add_settings_section(
        'bonddesign_sstoc_section_main',
        'TOC Display Settings',
        null,
        'simple-sticky-toc'
    );

    add_settings_field(
        'heading_depth',
        'Heading Depth',
        'bonddesign_sstoc_render_heading_depth_field',
        'simple-sticky-toc',
        'bonddesign_sstoc_section_main'
    );
}
function bonddesign_bonddesign_sstoc_sanitize_options($options)
{
    $allowed_depth = ['h2', 'h2-h3', 'h2-h4'];
    $options['heading_depth'] = in_array($options['heading_depth'], $allowed_depth, true)
        ? $options['heading_depth']
        : 'h2-h4';
    return $options;
}
function bonddesign_sstoc_render_heading_depth_field()
{
    $options = get_option('bonddesign_bonddesign_sstoc_options');
    $depth = $options['heading_depth'] ?? 'h2-h4';
    ?>
    <select name="bonddesign_bonddesign_sstoc_options[heading_depth]">
        <option value="h2" <?php selected($depth, 'h2'); ?>>h2 only</option>
        <option value="h2-h3" <?php selected($depth, 'h2-h3'); ?>>h2–h3</option>
        <option value="h2-h4" <?php selected($depth, 'h2-h4'); ?>>h2–h4 (default)</option>
    </select>
    <?php
}

function bonddesign_sstoc_render_settings_page()
{
    ?>
    <div class="wrap">
        <h1>Simple Sticky TOC</h1>
        <form action="options.php" method="post">
            <?php
            settings_fields('bonddesign_sstoc_settings');
            do_settings_sections('simple-sticky-toc');
            submit_button();
            ?>
        </form>
    </div>
    <?php
}
