<?php

if (!defined('ABSPATH'))
    exit;

add_action('add_meta_boxes', 'bonddesign_sstoc_add_metabox');
add_action('save_post', 'bonddesign_sstoc_save_metabox');

function bonddesign_sstoc_add_metabox()
{
    add_meta_box(
        'bonddesign_sstoc_metabox',
        'BNDDSGN_Simple Sticky TOC',
        'bonddesign_sstoc_render_metabox',
        ['post', 'page'],
        'side',
        'default'
    );
}

function bonddesign_sstoc_render_metabox($post)
{
    wp_nonce_field('bonddesign_sstoc_metabox_nonce', 'bonddesign_sstoc_metabox_nonce_field');
    $value = get_post_meta($post->ID, '_bonddesign_sstoc_disable', true);
    ?>
    <label>
        <input type="checkbox" name="bonddesign_sstoc_disable" value="1" <?php checked($value, '1'); ?>>
        Disable TOC for this post
    </label>
    <?php
}

function bonddesign_sstoc_save_metabox($post_id)
{
    $nonce = isset($_POST['bonddesign_sstoc_metabox_nonce_field'])
        ? sanitize_text_field(wp_unslash($_POST['bonddesign_sstoc_metabox_nonce_field']))
        : '';

    if (!wp_verify_nonce($nonce, 'bonddesign_sstoc_metabox_nonce')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (isset($_POST['bonddesign_sstoc_disable'])) {
        update_post_meta($post_id, '_bonddesign_sstoc_disable', '1');
    } else {
        delete_post_meta($post_id, '_bonddesign_sstoc_disable');
    }
}

