# Simple Sticky TOC

**Lightweight, customizable sticky Table of Contents for WordPress**
Responsive, with RTL support, per-post control, and theme overrides. No jQuery.

![Banner](assets/img/banner.png)

---

## 🔍 Features

- ✅ Automatically generates TOC from `h2–h4` headings
- 📱 Sticky, toggleable TOC for mobile
- 💻 Sticky sidebar TOC for desktop (absolute + sticky)
- 🌍 Full RTL support
- ❌ Option to disable TOC on specific posts
- 🎨 Theme override support for template, styles, and JS
- 💨 Clean code, no jQuery

---

## 📆 Installation

1. Upload the plugin to `/wp-content/plugins/simple-sticky-toc/`
2. Activate it via **Plugins → Installed Plugins**
3. By default, the TOC will be automatically inserted above post content

---

## ⚙️ Settings

Go to **Settings → BNDDSGN_Simple Sticky TOC** to configure:

- **Heading depth**: `h2`, `h2–h3`, or `h2–h4`
- **Per-post control**: toggle in the sidebar of the editor

## 🎨 Theme Overrides

You can override the plugin’s markup, styles, or JS from your theme.

Place any of the following files in:

```
your-theme/simple-sticky-toc/
```

Supported files:

- `toc-template.php` — override TOC markup
- `toc.css` — override styles
- `toc.js` — override behavior

These will be automatically loaded instead of plugin defaults.

---

## 🖼️ Screenshots

1. Sticky vertical TOC on desktop
2. Toggleable TOC on mobile
3. Admin settings for heading depth
4. RTL layout compatibility

---

## 🧑‍💻 Author

**Pavlo Bondarchuk**
[GitHub Profile](https://github.com/pavlo-bondarchuk)
[Plugin Repo](https://github.com/pavlo-bondarchuk/simple-sticky-toc)

---

## 📄 License

[GPLv2 or later](https://www.gnu.org/licenses/gpl-2.0.html)

---

## 🌐 Coming Soon

You’ll be able to download it via the official [WordPress Plugin Repository](https://wordpress.org/plugins/) after submission and approval.
