<?php
if ( ! defined( 'ABSPATH' ) ) exit;

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete custom post types and metadata
$posts = get_posts([
    'post_type' => 'menu_item',
    'numberposts' => -1,
    'post_status' => 'any'
]);

foreach ($posts as $post) {
    wp_delete_post($post->ID, true);
}

// Delete custom terms
$terms = get_terms(['taxonomy' => 'menu_section', 'hide_empty' => false]);
foreach ($terms as $term) {
    wp_delete_term($term->term_id, 'menu_section');
}
