<?php
/**
 * Template part for rendering the menu items grouped by Menu Section.
 *
 * This template loops through each menu section (taxonomy term),
 * queries for the menu items in that section, and displays them
 * using a helper template function `simpremed_get_template_part()`.
 *
 * @package SRMD
 */
if ( ! defined( 'ABSPATH' ) ) exit;

 if ( isset( $args['query'] ) && $args['query'] instanceof WP_Query ) {
	$query = $args['query'];

	if ( $query->have_posts() ) {
		echo '<div class="simpremed-menu-wrapper">';

		// Optional section title
		if ( ! empty( $args['section_slug'] ) && ! empty( $args['is_special'] ) ) {
			$term = get_term_by( 'slug', sanitize_text_field( $args['section_slug'] ), 'simpremed_menu_section' );
			if ( $term ) {
				echo '<h2 class="simpremed-section-title">' . esc_html( $term->name ) . '</h2>';
			}
		}

		// Optional section title when only special is set
		if ( empty( $args['section_slug'] ) && ! empty( $args['is_special'] ) ) {
			echo '<h2 class="simpremed-section-title">' . esc_html__( 'Specials', 'simple-restaurant-menu-display' ) . '</h2>';
		}

		echo '<div class="simpremed-menu-items">';
		while ( $query->have_posts() ) {
			$query->the_post();
			simpremed_get_template_part( 'simpremed-menu-item' );
		}
		echo '</div></div>';
		wp_reset_postdata();
	} else {
		echo '<p>' . esc_html__( 'No menu items found.', 'simple-restaurant-menu-display' ) . '</p>';
	}
	return;
}

// Retrieve all terms under the 'simpremed_menu_section' taxonomy, including empty ones.
$sections = get_terms([
	'taxonomy'   => 'simpremed_menu_section',
	'hide_empty' => false,
]);

// Sort terms by custom 'menu_order' meta value
usort( $sections, function( $a, $b ) {
	$order_a = (int) get_term_meta( $a->term_id, 'menu_order', true );
	$order_b = (int) get_term_meta( $b->term_id, 'menu_order', true );
	return $order_a - $order_b;
});

// Check if sections exist and there are no errors.
if ( ! empty( $sections ) && ! is_wp_error( $sections ) ) {
	echo '<div class="simpremed-menu-wrapper">';

	// Loop through each section (taxonomy term).
	foreach ( $sections as $section ) {
		echo '<div class="simpremed-menu-section">';
		echo '<h2 class="simpremed-section-title">' . esc_html( $section->name ) . '</h2>';

		// Query for menu items in this section, ordered by menu_order.
		$query = new WP_Query([
			'post_type'      => 'simpremed_menu_item',
			'posts_per_page' => -1,
			'tax_query'      => [
				[
					'taxonomy' => 'simpremed_menu_section',
					'field'    => 'term_id',
					'terms'    => $section->term_id,
				],
			],
			//'orderby'        => 'menu_order',
			//'order'          => 'ASC',
		]);

		// If posts are found, loop through and render each using a template part.
		if ( $query->have_posts() ) {
			echo '<div class="simpremed-menu-items">';
			while ( $query->have_posts() ) {
				$query->the_post();

				/**
				 * Custom function that includes a partial template file.
				 *
				 * Expected to render individual menu item details.
				 * Likely defined in plugin's includes or helpers.
				 */
				simpremed_get_template_part( 'simpremed-menu-item' );
			}
			echo '</div>';
		} else {
			// No menu items found for this section.
			echo '<p>' . esc_html__( 'No menu items found in this section.', 'simple-restaurant-menu-display' ) . '</p>';
		}

		// Restore original post data.
		wp_reset_postdata();

		echo '</div>'; // .simpremed-menu-section
	}

	echo '</div>'; // .simpremed-menu-wrapper
} else {
	// No sections found or there was an error fetching them.
	echo '<p>' . esc_html__( 'No menu sections found.', 'simple-restaurant-menu-display' ) . '</p>';
}
