<?php
/**
 * Template part for displaying a single menu item.
 *
 * Outputs:
 * - Title of the menu item
 * - "Special" badge if marked special
 * - Description content (if present)
 * - One or more quantity-price pairs
 *
 * Expects to be used within the loop, likely from a parent template like `simpremed-menu-loop`.
 *
 * @package Simpremed
 */

if ( ! defined( 'ABSPATH' ) ) exit;

// Get the currency symbol from plugin settings (default to ₹).
$currency    = simpremed_get_currency_symbol(); // Uses filterable function

// Check if this item is marked as "special" in post meta.
$is_special = get_post_meta( get_the_ID(), 'simpremed_is_special', true );

// Retrieve quantity and price options from post meta (JSON-encoded).
$quantities = get_post_meta( get_the_ID(), '_simpremed_quantities', true );

// Decode the quantities if set, or initialize as empty array.
$quantities = $quantities ? json_decode( $quantities, true ) : [];
?>

<div class="simpremed-menu-item">
	<h3 class="simpremed-item-title">
		<?php echo esc_html( get_the_title() ); ?>

		<?php if ( $is_special ) : ?>
			<span class="simpremed-special-badge">
				<?php esc_html_e( 'Special', 'simple-restaurant-menu-display' ); ?>
			</span>
		<?php endif; ?>
	</h3>

	<?php if ( get_the_content() ) : ?>
		<div class="simpremed-item-description">
			<?php echo wp_kses_post( wpautop( get_the_content() ) ); ?>
		</div>
	<?php endif; ?>

	<?php if ( $quantities && is_array( $quantities ) ) : ?>
		<div class="simpremed-prices">
			<?php foreach ( $quantities as $entry ) :
				$label = isset( $entry['label'] ) ? $entry['label'] : '';
				$price = isset( $entry['price'] ) ? (float) $entry['price'] : 0;
			?>
				<div class="simpremed-price-row">
					<span class="simpremed-qty-label"><?php echo esc_html( $label ); ?></span>
					<span class="simpremed-qty-price"><?php echo esc_html( $currency . number_format_i18n( $price, 2 ) ); ?></span>
				</div>
			<?php endforeach; ?>
		</div>
	<?php endif; ?>
</div>
